% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fml_resampler.R
\name{Resampler}
\alias{Resampler}
\title{Resampler}
\format{
[R6::R6Class] object.
}
\description{
Model validation by repeated bootstrapping
}
\details{
Uses repeated bootstrapping to validate models without a test data set.
For each experiment multiple metrics are measured.
For classification experiments the confusion matrix is calculated additionally.
In order to test hypotheses, either features or the response variable can be permuted.
}
\author{
Sebastian Malkusch
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{permute}}{returns the instance variable 'permute'.
(character)}

\item{\code{permute_alphabet}}{returns the instance variable 'permute_alphabet'.
(character)}

\item{\code{n_resample}}{returns the instance variable 'n_resample'.
(integer)}

\item{\code{fml_method}}{returns the instance variable 'fml_method'.
(character)}

\item{\code{fml_type}}{returns the instance variable 'fml_type'.
(character)}

\item{\code{fml_type_alphabet}}{returns the instance variable 'fml_type_alphabet'.
(character)}

\item{\code{pre_process_lst}}{returns the instance variable 'pre_process_lst'.
(character)}

\item{\code{hyper_parameters}}{returns the instance variable 'hyper_parameters'.
(list)}

\item{\code{response_var}}{returns the instance variable 'response_var'.
(character)}

\item{\code{n_features}}{returns the instance variable 'n_features'.
(integer)}

\item{\code{strata_var}}{returns the instance variable 'strata_var'.
(character)}

\item{\code{metrics_df}}{returns the instance variable 'metrics_df'.
(tibble::tibble)}

\item{\code{confusion_df}}{returns the instance variable 'confusion_df'.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Resampler-new}{\code{Resampler$new()}}
\item \href{#method-Resampler-print}{\code{Resampler$print()}}
\item \href{#method-Resampler-fit}{\code{Resampler$fit()}}
\item \href{#method-Resampler-clone}{\code{Resampler$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Resampler-new"></a>}}
\if{latex}{\out{\hypertarget{method-Resampler-new}{}}}
\subsection{Method \code{new()}}{
checks, if permutation is requested.
If true, performs the permutation task.


Checks if ml.type is classification.
If true, calculates confusion matrix.


Creates and returns instance of
Resampler class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Resampler$new(
  n_resample = 500,
  fml_method = "pcr",
  fml_type = "classification",
  hyper_parameters = "list",
  pre_process_lst = c("center", "scale"),
  permute = NULL,
  n_features = 0,
  response_var = "character",
  strata_var = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n_resample}}{number of bootstrap resamples.
The default is 500 (integer)}

\item{\code{fml_method}}{ML model that is being used.
The default is 'pcr' (character).}

\item{\code{fml_type}}{ML model type. Needs to be 'classification',
'regression' or 'censored'.
Default is 'classification' (character).}

\item{\code{hyper_parameters}}{List of model hyper parameters.
(list)}

\item{\code{pre_process_lst}}{Vector of pre-processing steps.
Default is 'c("center", "scale")' (character).}

\item{\code{permute}}{Permutation method. Needs to be 'none', 'features'
or 'response'.
(character)}

\item{\code{n_features}}{Number of features to be chosen in the permutation
experiment.
Default is 0 (integer).}

\item{\code{response_var}}{Response variable of the model (character).}

\item{\code{strata_var}}{Stratification variable (character).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Resampler
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Resampler-print"></a>}}
\if{latex}{\out{\hypertarget{method-Resampler-print}{}}}
\subsection{Method \code{print()}}{
Print instance variables of Resampler class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Resampler$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
character
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Resampler-fit"></a>}}
\if{latex}{\out{\hypertarget{method-Resampler-fit}{}}}
\subsection{Method \code{fit()}}{
Runs the bootstrap analysis based on the instance
variables chosen under initialize.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Resampler$fit(data_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{data set to be analyzed (tibble::tibble).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Resampler-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Resampler-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Resampler$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
