% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixture.r
\name{mixsurv}
\alias{mixsurv}
\alias{dmixsurv}
\alias{pmixsurv}
\alias{qmixsurv}
\alias{rmixsurv}
\alias{hmixsurv}
\alias{Hmixsurv}
\alias{mean_mixsurv}
\alias{rmst_mixsurv}
\alias{pmixsurv}
\alias{hmixsurv}
\alias{Hmixsurv}
\alias{dmixsurv}
\alias{qmixsurv}
\alias{rmixsurv}
\alias{rmst_mixsurv}
\alias{mean_mixsurv}
\title{Mixture cure models}
\usage{
pmixsurv(pfun, q, theta, ...)

hmixsurv(dfun, pfun, x, theta, ...)

Hmixsurv(pfun, x, theta, ...)

dmixsurv(dfun, pfun, x, theta, ...)

qmixsurv(pfun, p, theta, ...)

rmixsurv(pfun, n, theta, ...)

rmst_mixsurv(pfun, t, theta, ...)

mean_mixsurv(pfun, theta, ...)
}
\arguments{
\item{pfun}{The base distribution's cumulative distribution function.}

\item{theta}{The estimated cure fraction.}

\item{...}{additional parameters to be passed to the pdf or cdf of the base
distribution.}

\item{dfun}{The base distribution's probability density function.}

\item{x, q, t}{Vector of times.}

\item{p}{Vector of probabilities.}

\item{n}{Number of random numbers to simulate.}
}
\value{
\code{dmixsurv} gives the density, \code{pmixsurv} gives the
distribution function, \code{hmixsurv} gives the hazard and
\code{Hmixsurv} gives the cumulative hazard.

\code{qmixsurv} gives the quantile function, which is computed by crude
numerical inversion.

\code{rmixsurv} generates random survival times by using \code{qmixsurv}
on a sample of uniform random numbers.  Due to the numerical root-finding
involved in \code{qmixsurv}, it is slow compared to typical random number
generation functions.

\code{mean_mixsurv} and \code{rmst_mixsurv} give the mean and restricted
mean survival times, respectively.
}
\description{
Probability density, distribution, quantile, random generation, hazard
cumulative hazard, mean, and restricted mean functions for generic
mixture cure models.  These distribution functions take as arguments
the corresponding functions of the base distribution used.
}
\author{
Jordan Amdahl <jrdnmdhl@gmail.com>
}
\keyword{distribution}
