% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trie.R
\name{build_trie}
\alias{build_trie}
\title{Trie Builder}
\usage{
build_trie(lm, token_dict, lexicon, word_dict, separator_idx)
}
\arguments{
\item{lm}{a KenLM instance}

\item{token_dict}{a DIctionary instance with the tokens.}

\item{lexicon}{a named list with the words and its tokens.}

\item{word_dict}{a Dictionary instance with the words.}

\item{separator_idx}{an integer. The index of the separator token.}
}
\value{
a populated Trie instance.
}
\description{
Helper to build a trie with a Dictionary.
}
\examples{
library(flashlighttext)
lm <- ZeroLM$new()
lexicon <- list(
  "hello" = list(c("h", "e", "l", "l", "o", "|")),
  "world" = list(c("w", "o", "r", "l", "d", "|")),
  "<unk>" = list()
)
word_dict <- create_word_dict(lexicon)
token_dict <- Dictionary$new(c("h", "e", "l", "o", "|", "w", "r", "d", "<unk>")) 
token_dict$add_entry("<1>")
trie <- build_trie(
  lm = lm,
  token_dict = token_dict,
  lexicon = lexicon, 
  word_dict = word_dict,
  separator_idx = token_dict$get_index("|")
)
}
