% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strings.R
\name{str_nth_instance_indices}
\alias{str_nth_instance_indices}
\title{Get the indices of the \eqn{n}th instance of a pattern.}
\usage{
str_nth_instance_indices(strings, pattern, n)
}
\arguments{
\item{strings}{A character vector.}

\item{pattern}{A character vector. Pattern(s) specified like the pattern(s)
in the stringr package (e.g. look at \code{\link[stringr:str_locate]{stringr::str_locate()}}). If
this has length >1 its length must be the same as that of \code{string}.}

\item{n}{Then \eqn{n} for the \eqn{n}th instance of the pattern.}
}
\value{
A two-column matrix. The \eqn{i}th row of this matrix gives the start and end indices of the \eqn{n}th instance of \code{pattarn} in the \emph{i}th element of \code{strings}.
}
\description{
The \eqn{n}th instance of an pattern will cover a series of character
indices. This function tells you which indices those are.
}
\examples{
str_nth_instance_indices(c("abcdabcxyz", "abcabc"), "abc", 2)

}
