% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppd.R
\name{ppd}
\alias{ppd}
\title{Compute Peak Persistence Diagram}
\usage{
ppd(
  f,
  time,
  max_lam = 2,
  num_lam = 10,
  pt = 0.15,
  penalty_method = c("roughness", "geodesic", "norm"),
  centroid_type = c("mean", "median"),
  center_warpings = TRUE,
  smooth_data = FALSE,
  sparam = 25L,
  parallel = TRUE,
  cores = -1,
  optim_method = c("DP", "DPo", "DP2", "RBFGS"),
  max_iter = 20L
)
}
\arguments{
\item{f}{A numeric matrix of shape \eqn{M \times N} specifying a sample of
\eqn{N} curves observed on a grid of size \eqn{M}.}

\item{time}{A numeric vector of length \eqn{M} specifying the common grid on
which all curves \code{f} have been observed.}

\item{max_lam}{maximum value of lambda. Defaults to \code{2}}

\item{num_lam}{number of steps. Defaults to \code{10}}

\item{pt}{the percentile of negative curvature of raw data Defaults to \code{.15}}

\item{penalty_method}{A string specifying the penalty term used in the
formulation of the cost function to minimize for alignment. Choices are
\code{"roughness"} which uses the norm of the second derivative, \code{"geodesic"}
which uses the geodesic distance to the identity and \code{"norm"} which uses
the Euclidean distance to the identity. Defaults to \code{"roughness"}.}

\item{centroid_type}{A string specifying the type of centroid to align to.
Choices are \code{"mean"} or \code{"median"}. Defaults to \code{"mean"}.}

\item{center_warpings}{A boolean specifying whether to center the estimated
warping functions. Defaults to \code{TRUE}.}

\item{smooth_data}{A boolean specifying whether to smooth curves using a box
filter. Defaults to \code{FALSE}.}

\item{sparam}{An integer value specifying the number of times to apply the
box filter. Defaults to \code{25L}. This is used only when \code{smooth_data = TRUE}.}

\item{parallel}{A boolean specifying whether to run calculations in parallel.
Defaults to \code{TRUE}.}

\item{cores}{number of cores in parallel (default=-1, means all cores)}

\item{optim_method}{A string specifying the algorithm used for optimization.
Choices are \code{"DP"}, \code{"DPo"}, and \code{"RBFGS"}. Defaults to \code{"DP"}.}

\item{max_iter}{An integer value specifying the maximum number of iterations.
Defaults to \code{20L}.}
}
\value{
lam_opt optimal lam
}
\description{
This computes the peak persistence diagram over a range of
lambda. This can help determine the proper elasticity (penalty).
This can be slow and recommended to run in parallel
}
\examples{
\dontrun{
  out <- ppd(simu_data$f, simu_data$time)
}
}
\references{
Kim, Woo Min, Sutanoy Dasgupta, and Anuj Srivastava. "Peak-persistence diagrams for estimating shapes and functions from noisy data." arXiv preprint arXiv:2305.04826 (2023).
}
\keyword{alignment}
\keyword{srsf}
