% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_contexts.R
\name{randomize_context}
\alias{randomize_context}
\title{Randomize an Existing Formal Context}
\usage{
randomize_context(fc, method = "swap", iterations = NULL)
}
\arguments{
\item{fc}{(\code{FormalContext}) The context to randomize.}

\item{method}{(character) The randomization strategy:
\itemize{
\item \code{"swap"}: Edge Swapping (Curveball algorithm). Preserves exact row sums and column sums (marginal distributions). The structure changes, but the statistics of objects and attributes remain identical.
\item \code{"rewire"}: Edge Rewiring. Preserves only the global density (total number of 1s). Row and column sums may change.
}}

\item{iterations}{(integer) Number of swap/rewire operations to perform.
Default is \code{10 * number of 1s}, which is usually sufficient for mixing.}
}
\value{
A new \code{FormalContext} object with the randomized incidence.
}
\description{
Modifies the incidence matrix of a formal context to create a random variation
while preserving certain statistical properties. This is essential for statistical
significance testing in FCA (e.g., "is this concept structure random?").
}
\examples{
data(planets)
fc <- FormalContext$new(planets)

# 1. Edge Swapping (Preserves degree distribution)
# Useful for null-model testing
fc_rand_swap <- randomize_context(fc, method = "swap")

# Verify marginals are preserved
colSums(fc$incidence())
colSums(fc_rand_swap$incidence())

# 2. Rewiring (Preserves only density)
fc_rand_rewire <- randomize_context(fc, method = "rewire")

}
