% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim.r
\name{trim,GRaster-method}
\alias{trim,GRaster-method}
\alias{trim}
\title{Remove rows and columns from a raster that are all NA}
\usage{
\S4method{trim}{GRaster}(x, pad = 0)
}
\arguments{
\item{x}{A \code{GRaster}.}

\item{pad}{Numeric integer: Number of \code{NA} rows and columns to retain. The default is 0.}
}
\value{
A \code{GRaster}.
}
\description{
This function removes any rows and columns from  a \code{GRaster} that are all \code{NA}.

If the \code{GRaster} is a stack of rasters, then the rasters will all be trimmed to the same extent such that none have any rows or columns that are all \code{NA}. In other words, if at least one raster in the stack has a non-\code{NA} cell in a row or column, all rasters will retain that row or column.
}
\examples{
if (grassStarted()) {

# Setup
library(terra)

# Elevation raster
madElev <- fastData("madElev")

# Convert SpatRaster to a GRaster:
elev <- fast(madElev)

# Trim NA rows/columns:
trimmedElev <- trim(elev)
dim(elev)
dim(trimmedElev)

# Trim a "stack" of rasters. We will artificially add NA rows and columns to
# one raster to demonstrate how the trim() function removes only rows/columns
# that are NA for *all* rasters.
elevNAs <- elev

fun <- " = if(col() > ncols() - 200, null(), madElev)"
elevNAs <- app(elevNAs, fun)

# Notice raster is "narrower" because we added NA columns
plot(elevNAs)

elevs <- c(elev, elevNAs)
trimmedElevs <- trim(elevs)
trimmedElevNAs <- trim(elevNAs)

dim(elevs)
dim(trimmedElevNAs)
dim(trimmedElevs)

}
}
\seealso{
\code{\link[terra:trim]{terra::trim()}}, \code{\link[=extend]{extend()}}, and \strong{GRASS} tool \code{g.region}
}
