% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topGen.R
\name{topGen}
\alias{topGen}
\title{Extract the top most species-rich genera of any plant family}
\usage{
topGen(family,
       limit = 10,
       verbose = TRUE,
       save = FALSE,
       dir = "results_topGen",
       filename = "output")
}
\arguments{
\item{family}{Either one family name or a vector of multiple families that
is present in POWO.}

\item{limit}{A defined numerical value to limit the most diverse genera to be
selected within each plant family. The default is to select the top ten
richest genera.}

\item{verbose}{Logical, if \code{FALSE}, a message showing each step during
the POWO search will not be printed in the console in full.}

\item{save}{Logical, if \code{TRUE}, the search results will be saved on disk.}

\item{dir}{Pathway to the computer's directory, where the file will be saved
provided that the argument \code{save} is set up in \code{TRUE}. The default
is to create a directory named \strong{results_topGen} and the search results
will be saved within a subfolder named after the current date.}

\item{filename}{Name of the output file to be saved. The default is to create
a file entitled \strong{output}.}
}
\value{
A table with the following fields: family, genus, authors,
scientific_name, species_number (counting of species within each genus),
kew_id (each genus code within Kew's databases), powo_uri (URI to access each
genus in POWO).
}
\description{
Produces a CSV file listing the top most diverse genera
of any target botanical family of vascular plants at
\href{https://powo.science.kew.org/}{Plants of the World Online (POWO)}.
}
\examples{
\dontrun{
library(expowo)

topGen(family = "Lecythidaceae",
       limit = 10,
       save = FALSE,
       dir = "results_topGen",
       filename = "Lecythidaceae_top_ten")
}

}
\seealso{
\code{\link{POWOcodes}}
}
\author{
Debora Zuanny & Domingos Cardoso
}
