% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_TestItemFunctions.R
\name{PhiCoefficient}
\alias{PhiCoefficient}
\alias{PhiCoefficient.default}
\alias{PhiCoefficient.binary}
\title{Phi-Coefficient}
\usage{
PhiCoefficient(U, na = NULL, Z = NULL, w = NULL)

\method{PhiCoefficient}{default}(U, na = NULL, Z = NULL, w = NULL)

\method{PhiCoefficient}{binary}(U, na = NULL, Z = NULL, w = NULL)
}
\arguments{
\item{U}{Either an object of class "exametrika" or raw data. When raw data is given,
it is converted to the exametrika class with the \code{\link{dataFormat}} function.}

\item{na}{Values to be treated as missing values.}

\item{Z}{Missing indicator matrix of type matrix or data.frame. Values of 1 indicate
observed responses, while 0 indicates missing data.}

\item{w}{Item weight vector specifying the relative importance of each item.}
}
\value{
A matrix of phi coefficients with exametrika class.
Each element (i,j) represents the phi coefficient between items i and j.
The matrix is symmetric with ones on the diagonal.
}
\description{
The phi coefficient is the Pearson's product moment correlation coefficient
between two binary items. This function is applicable only to binary response data.
The coefficient ranges from -1 to 1, where 1 indicates perfect positive correlation,
-1 indicates perfect negative correlation, and 0 indicates no correlation.
}
\note{
This function is implemented using a binary data compatibility wrapper and
will raise an error if used with polytomous data.
}
\examples{
# example code
# Calculate Phi-Coefficient using sample dataset J15S500
PhiCoefficient(J15S500)
}
