% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonparametric_tests.R
\name{generalized_sign_test}
\alias{generalized_sign_test}
\title{An event study binomial sign test.}
\usage{
generalized_sign_test(list_of_returns, event_start, event_end)
}
\arguments{
\item{list_of_returns}{a list of objects of S3 class \code{returns}, each
element of which is treated as a security.}

\item{event_start}{an object of \code{Date} class giving the first date of
the event period.}

\item{event_end}{an object of \code{Date} class giving the last date of the
event period.}
}
\value{
A data frame of test's statistics and significances.
}
\description{
A binomial sign test which determines whether the frequency of positive
abnormal returns in the event period is significantly different from the
frequency in the estimation period.
}
\details{
This test is application of the binomial test to the event study,
which indicates whether the cross-sectional frequency of positive abnormal
returns is significantly different from the expected. This test is stable
to outliers, in other words allows for checking if the result is driven by
few companies with extremely large abnormal performance. For this test the
estimation period and the event period must not overlap, otherwise an error
will be thrown. This test uses an estimate from the estimation period instead
of using naive value of expected frequency 0.5. The test statistic is assumed
to have a normal distribution. Typically the test is used together with
parametric tests. The test is well-specified for the case, when
cross-sectional abnormal returns are not symmetric. Also this procedure is
less sensitive to extreme returns than the rank test. The significance levels
of \eqn{\alpha} are 0.1, 0.05, and 0.01 (marked respectively by *, **, and
***).
}
\examples{
\dontrun{
library("magrittr")
rates_indx <- get_prices_from_tickers("^STOXX50E",
                                      start = as.Date("2000-01-01"),
                                      end = as.Date("2002-01-01"),
                                      quote = "Close",
                                      retclass = "zoo") \%>\%
    get_rates_from_prices(quote = "Close",
                          multi_day = TRUE,
                          compounding = "continuous")
tickers <- c("ALV.DE", "CS.PA", "G.MI", "HNR1.HA", "HSX.L", "MUV2.DE",
             "RSA.L", "TOP.CO")
get_prices_from_tickers(tickers,
                        start = as.Date("2000-01-01"),
                        end = as.Date("2002-01-01"),
                        quote = "Close",
                        retclass = "zoo") \%>\%
    get_rates_from_prices(quote = "Close",
                          multi_day = TRUE,
                          compounding = "continuous") \%>\%
    apply_market_model(regressor = rates_indx,
                       same_regressor_for_all = TRUE,
                       market_model = "sim",
                       estimation_method = "ols",
                       estimation_start = as.Date("2001-03-26"),
                       estimation_end = as.Date("2001-09-10")) \%>\%
    generalized_sign_test(event_start = as.Date("2001-09-11"),
                          event_end = as.Date("2001-09-28"))
}
## The result of the code above is equivalent to:
data(securities_returns)
generalized_sign_test(list_of_returns = securities_returns,
                      event_start =  as.Date("2001-09-11"),
                      event_end = as.Date("2001-09-28"))

}
\references{
\itemize{
\item McConnell J.J., Muscarella C.J. \emph{Capital expenditure plans and
firm value} Journal of Financial Economics, 14:399-422, 1985.
\item Cowan A.R. \emph{Nonparametric Event Study Tests}. Review of
Quantitative Finance and Accounting, 2:343-358, 1992.
}
}
\seealso{
\code{\link{nonparametric_tests}}, \code{\link{sign_test}},
\code{\link{corrado_sign_test}}, \code{\link{rank_test}},
\code{\link{modified_rank_test}}, and \code{\link{wilcoxon_test}}.
}
