% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/series.temporales.R
\name{series.temporales}
\alias{series.temporales}
\title{Series temporales.}
\usage{
series.temporales(x,
       variable = NULL,
       inicio_anual = 1,
       periodo_inicio = 1,
       frecuencia = 4,
       orden = frecuencia,
       prediccion_tendencia = FALSE,
       grafico = FALSE,
       exportar = FALSE)
}
\arguments{
\item{x}{Conjunto de datos. Puede ser un vector o un dataframe.}

\item{variable}{Es un vector (numérico o carácter) que indica las variables a seleccionar de \code{x}. Si \code{x} se refiere una sola variable, el argumento variable es NULL. En caso contrario, es necesario indicar el nombre o posición (número de columna) de la variable.}

\item{inicio_anual}{Año de inicio de la serie. Por defecto \code{inicio_anual = 1}.}

\item{periodo_inicio}{Periodo de inicio de la serie. Por defecto \code{perido_inicio = 1}, es decir, el primer periodo del año 1.}

\item{frecuencia}{Periodificación de la serie. Por defecto \code{frecuencia = 4}.
Si anual, frecuencia = 1.
Si semestral, frecuencia = 2.
Si cuatrimestral, frecuencia = 3.
Si trimestral, frecuencia = 4.
Si bimestral, frecuencia = 6.
Si mensual, frecuencia = 12.
Si semanal, frecuencia = 52.
Si diario, frecuencia = 360.}

\item{orden}{Orden (o puntos) de cálculo de la media móvil. Por defecto \code{orden = frecuencia}.}

\item{prediccion_tendencia}{vector de periodo temporal (\code{t=0}, origen de la serie) para el que se quiere obtener una predicción de la tendencia de la serie objeto de estudio.}

\item{grafico}{Es un valor lógico. Por defecto \code{grafico = FALSE}. Si se quiere obtener una representación gráfica la serie original, las medias móviles y la estimación por regresión de la tendencia, cambiar a \code{grafico = TRUE}.}

\item{exportar}{Para exportar los principales resultados a una hoja de cálculo Excel (\code{exportar = TRUE}).}
}
\value{
Esta función devuelve un objeto de la clase \code{list}.
}
\description{
Esta función utiliza el método de las medias móviles (centradas) para extraer la tendencia de una serie temporal.
A partir de las medias móviles, también se obtienen los índices de variación estacional (IVE).

Lee el código QR para video-tutorial sobre el uso de la función con un ejemplo.

\if{html}{\figure{qrseriestemporales.png}{options: width="25\%" alt="Figure: qrmuestra1.png"}}
\if{latex}{\figure{qrseriestemporales.png}{options: width=3cm}}
}
\examples{

ejemplo_serie <- series.temporales(turistas2,
variable=2,
inicio_anual=2000,
periodo_inicio = 1)

}
\references{
Esteban García, J. y otros. (2005). Estadística descriptiva y nociones de probabilidad. Paraninfo. ISBN: 9788497323741

Newbold, P, Carlson, W. y Thorne, B. (2019). Statistics for Business and Economics, Global Edition. Pearson. ISBN: 9781292315034

Murgui, J.S. y otros. (2002). Ejercicios de estadística Economía y Ciencias sociales. tirant lo blanch. ISBN: 9788484424673
}
\seealso{
\code{\link{regresion.simple}}
}
\author{
\strong{Vicente Coll-Serrano}.
\emph{Métodos Cuantitativos para la Medición de la Cultura (MC2). Economía Aplicada.}

\strong{Rosario Martínez Verdú}.
\emph{Economía Aplicada.}

Facultad de Economía. Universidad de Valencia (España)
}
