% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_vars.R, R/set_vars.R
\name{get_vars}
\alias{get_vars}
\alias{get_vars.epiflows}
\alias{set_vars}
\alias{set_vars<-}
\alias{set_vars.epiflows}
\alias{set_vars<-.epiflows}
\title{Access location metadata}
\usage{
get_vars(x, ...)

\method{get_vars}{epiflows}(x, what = NULL, id = TRUE, vector = FALSE, ...)

set_vars(x, ...)

set_vars(x, name) <- value

\method{set_vars}{epiflows}(x, ...)

\method{set_vars}{epiflows}(x, name) <- value
}
\arguments{
\item{x}{An \code{epiflows} object.}

\item{...}{For \code{set_vars()}, any number of variables defined in
\code{\link[=global_vars]{global_vars()}} that can be used for mapping or modelling. This is unused
in \code{get_vars()}}

\item{what}{a valid character string specifying the variable desired. If
`NULL` (default), the names of the available vars will be returned.}

\item{id}{a logical. If `TRUE` (default), the `id` column of the locations
will be the first column of the data frame. if `FALSE`, the variable will
be returned with identifiers as row names.}

\item{vector}{if `TRUE` the result will be coerced into a vector (or a matrix in the case of coordinates)}

\item{name}{the name of the variable in \code{\link[=global_vars]{global_vars()}} to assign}

\item{value}{the name of the column in the locations data}
}
\value{
A data frame with the variables requested
}
\description{
This accessor extracts variables from the \code{locations} data frame in an
\code{epiflow} object. \code{get_vars} is a generic with a method defined for
\code{epiflows} objects.
}
\examples{
data("Brazil_epiflows")
get_vars(Brazil_epiflows) # defined global variables pointint to column names
get_vars(Brazil_epiflows, "duration_stay")
get_vars(Brazil_epiflows, "duration_stay", vector = TRUE)
}
\seealso{
\code{\link[=global_vars]{global_vars()}}; \code{\link[=make_epiflows]{make_epiflows()}}; \code{\link[=get_pop_size]{get_pop_size()}}; \code{\link[=get_id]{get_id()}}
}
\author{
Thibaut Jombart, Zhian Kamvar
}
