% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_risk_spread.R
\name{estimate_risk_spread}
\alias{estimate_risk_spread}
\alias{estimate_risk_spread.default}
\alias{estimate_risk_spread.epiflows}
\title{Travel-related disease cases spreaded to other locations from an infectious
location}
\usage{
estimate_risk_spread(...)

\method{estimate_risk_spread}{default}(
  location_code = character(0),
  location_population = numeric(0),
  num_cases_time_window = numeric(0),
  first_date_cases = character(0),
  last_date_cases = character(0),
  num_travellers_to_other_locations = numeric(0),
  num_travellers_from_other_locations = numeric(0),
  avg_length_stay_days = numeric(0),
  r_incubation = function(n) {
 },
  r_infectious = function(n) {
 },
  n_sim = 1000,
  return_all_simulations = FALSE,
  ...
)

\method{estimate_risk_spread}{epiflows}(
  x,
  location_code = character(0),
  r_incubation = function(n) {
 },
  r_infectious = function(n) {
 },
  n_sim = 1000,
  return_all_simulations = FALSE,
  ...
)
}
\arguments{
\item{...}{Arguments passed onto the default method.}

\item{location_code}{a character string denoting the infectious location code}

\item{location_population}{population of the infectious location}

\item{num_cases_time_window}{cumulative number of cases in infectious
location in time window}

\item{first_date_cases}{string with the date of the first disease case in
infectious location ("YYYY-MM-DD")}

\item{last_date_cases}{string with the date of the last disease case in
infectious location ("YYYY-MM-DD")}

\item{num_travellers_to_other_locations}{number of travellers from the
infectious location visiting other locations (T_D)}

\item{num_travellers_from_other_locations}{number of travellers from other
locations visiting the infectious location (T_O)}

\item{avg_length_stay_days}{average length of stay in days of travellers from
other locations visiting the infectious location. This can be a common
number for all locations or a vector with different numbers for each
location}

\item{r_incubation}{a function with a single argument \code{n}
generating 'n' random incubation periods}

\item{r_infectious}{a function with a single argument \code{n}
generating 'n' random durations of infectious period}

\item{n_sim}{number of simulations from the incubation and
infectious distributions}

\item{return_all_simulations}{logical value indicating whether the returned object is a data frame with all simulations
(\code{return_all_simulations = TRUE}) or a data frame with the mean and lower and upper limits of a 95\% confidence interval of
the number of cases spread to each location (\code{return_all_simulations = FALSE})}

\item{x}{an epiflows object}
}
\value{
if \code{return_all_simulations} is \code{TRUE}, data frame with all simulations. If \code{return_all_simulations} is \code{FALSE},
data frame with the mean and lower and upper limits of a 95\% confidence interval of the number
of cases spread to each location
}
\description{
Calculates the mean and 95\% confidence interval of the estimated number of
disease cases that could potentially seed a disease outbreak in the locations
they are travelling to, comprising exportations (infected residents of the infectious
location travelling abroad during the incubation or infectious period), and
importations (international tourists infected by the disease during
their stay in the infectious location and returning to their home location).
The mean and 95\% confidence intervals are obtained by numerically sampling
\code{n_sim} times from the incubation and infectious period distributions.
If parameter \code{return_all_simulations} is set to \code{TRUE}, the function returns all simulations
for each location.
}
\examples{
## Using an epiflows object --------------------------------

data("YF_flows")
data("YF_locations")
ef <- make_epiflows(flows         = YF_flows, 
                    locations     = YF_locations, 
                    pop_size      = "location_population",
                    duration_stay = "length_of_stay",
                    num_cases     = "num_cases_time_window",
                    first_date    = "first_date_cases",
                    last_date     = "last_date_cases"
)
## functions generating incubation and infectious periods
incubation <- function(n) {
  rlnorm(n, 1.46, 0.35)
}

infectious <- function(n) {
  rnorm(n, 4.5, 1.5/1.96)
}

res <- estimate_risk_spread(ef, 
                            location_code          = "Espirito Santo",
                            r_incubation           = incubation,
                            r_infectious           = infectious,
                            n_sim                  = 1e5,
                            return_all_simulations = TRUE)
boxplot(res, las = 3)

## Using other data --------------------------------------------------
data(YF_Brazil)
indstate <- 1 # "Espirito Santo" (indstate = 1), 
              # "Minas Gerais" (indstate = 2), 
              # "Southeast Brazil" (indstate = 5)

res <- estimate_risk_spread(
  location_code = YF_Brazil$states$location_code[indstate], 
  location_population = YF_Brazil$states$location_population[indstate], 
  num_cases_time_window = YF_Brazil$states$num_cases_time_window[indstate], 
  first_date_cases = YF_Brazil$states$first_date_cases[indstate], 
  last_date_cases = YF_Brazil$states$last_date_cases[indstate],
  num_travellers_to_other_locations = YF_Brazil$T_D[indstate,],
  num_travellers_from_other_locations = YF_Brazil$T_O[indstate,],
  avg_length_stay_days = YF_Brazil$length_of_stay,
  r_incubation = incubation,
  r_infectious = infectious,
  n_sim = 100000,
  return_all_simulations = FALSE
)
head(res)

}
\references{
Dorigatti I, Hamlet A, Aguas R, Cattarino L, Cori A, Donnelly CA,
Garske T, Imai N, Ferguson NM. International risk of yellow fever spread from
the ongoing outbreak in Brazil, December 2016 to May 2017. Euro Surveill.
2017;22(28):pii=30572. DOI: \doi{10.2807/1560-7917.ES.2017.22.28.30572}
}
\seealso{
Construction of epiflows object: \code{\link[=make_epiflows]{make_epiflows()}}\cr
Default variables used in the epiflows implementation: \code{\link[=global_vars]{global_vars()}}\cr
Access metadata from the epiflows object: \code{\link[=get_vars]{get_vars()}}
}
\author{
Paula Moraga, Zhian Kamvar (epiflows class implementation)
}
