% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emuR-objDocs.R
\name{emuRsegs}
\alias{emuRsegs}
\alias{segment}
\alias{list}
\title{emuR segment list}
\format{
Attributed data.frame, one row per segment descriptor.

Data frame columns are:
\itemize{ 
  \item labels: sequenced labels of segment concatenated by '->'
  \item start: onset time in milliseconds
  \item end: offset time in milliseconds
  \item session: session name
  \item bundle: bundle name
  \item level: level name
  \item type: type of "segment" row: 'ITEM': symbolic item, 'EVENT': event item, 'SEGMENT': segment

}
Additional hidden columns:
\itemize{
 \item utts: utterance name (for compatibility to \link{emusegs} class)
 \item db_uuid: UUID of emuDB
 \item startItemID: item ID of first element of sequence
 \item endItemID: item ID of last element of sequence
 \item sampleStart: start sample position
 \item sampleEnd: end sample position
 \item sampleRate: sample rate
}

Attributes:
\itemize{
  \item database: name of emuDB
  \item query: Query string
  \item type: type ('segment' or 'event') (for compatibility to \link{emusegs} class)
}
}
\description{
An emuR segment list is a list of segment descriptors. Each segment 
descriptor describes a sequence of annotation elements. The list is
usually a result of an emuDB query using function \code{\link{query}}.
}
\details{
Each row shows the annotation label sequence, the start and end position 
in time, session and bundle names, level name and type.
Additionally the row contains the UUID of the emuDB, the ID's of start 
and end elements and the corresponding start and end position as sample 
count and the sample rate. These columns are not printed by default. 
The print method of emuRsegs hides them. To print all columns of a segment 
list object use the print method of \code{\link{data.frame}}.
For example to print all columns of an emuRsegs segmentlist \code{sl} type:
\code{print.data.frame(sl)}
Though the segment descriptors have references to the annotations, the label 
and sample/time position information is not updated if any of them change. The 
values of the segment list may get invalid if the the database is modified.
A segment may consist only of one single element, in this case start and end ID are equal.
An emuR segment list is the default result of \code{\link{query}} and can 
be used to get track data using \code{\link{get_trackdata}}.
The emuRsegs class inherits \link{emusegs} and hence \code{\link{data.frame}}
}
\seealso{
\code{\link{query}},\code{\link{get_trackdata}},\link{emusegs}
}
\keyword{classes}
