% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting_functions.R
\name{irt_data}
\alias{irt_data}
\title{Create a Stan data list from an item response matrix or from long-form data.}
\usage{
irt_data(response_matrix = matrix(), y = integer(), ii = integer(),
  jj = integer(), covariates = data.frame(), formula = ~1)
}
\arguments{
\item{response_matrix}{An item response matrix.
Columns represent items and rows represent persons.
NA may be supplied for missing responses.
The lowest score for each item should be 0, with exception to rating scale
models.
\code{y}, \code{ii}, and \code{jj} should not be supplied if a response
matrix is given.}

\item{y}{A vector of scored responses for long-form data.
The lowest score for each item should be 0, with exception to rating scale
models.
NAs are not permitted, but missing responses may simply be ommitted
instead.
Required if \code{response_matrix} is not supplied.}

\item{ii}{A vector indexing the items in \code{y}.
This must consist of consecutive integers starting at 1.
\code{\link{labelled_integer}} may be used to create a suitable vector.
Required if \code{response_matrix} is not supplied.}

\item{jj}{A vector indexing the persons in \code{y}.
This must consist of consecutive integers starting at 1.
\code{\link{labelled_integer}} may be used to create a suitable vector.
Required if \code{response_matrix} is not supplied.}

\item{covariates}{An optional data frame containing (only) person-covariates.
It must contain one row per person or be of the same length as \code{y},
\code{ii}, and \code{jj}. If it contains one row per person, it must be in
the same order as the response matrix (or \code{unique(jj)}). If it has a
number of columns equal to the length of \code{y},
\code{ii}, and \code{jj}, it must be in the same order as \code{jj} (for
example, it may be a subset of columns from the same data frame that contains
\code{y}, \code{ii}, and \code{jj}).}

\item{formula}{An optional formula for the latent regression that is applied
to \code{covariates}. The left side  should be blank (for example,
\code{~ v1 + v2}). By default it includes only a model intercept,
interpretable as the mean of the person distribution. If set to
\code{NULL}, then \code{covariates} is used directly  as the design matrix
for the latent regression.}
}
\value{
A data list suitable for \code{\link{irt_stan}}.
}
\description{
Create a Stan data list from an item response matrix or from long-form data.
}
\examples{
# For a response matrix ("wide-form" data) with person covariates:
spelling_list <- irt_data(response_matrix = spelling[, 2:5],
                          covariates = spelling[, "male", drop = FALSE],
                          formula = ~ 1 + male)

# Alternatively, the same may be created by:
W <- cbind(intercept = 1, spelling[, "male"])
spelling_list <- irt_data(response_matrix = spelling[, 2:5],
                          covariates = W,
                          formula = NULL)

# For long-form data (one row per item-person pair):
agg_list_1 <- irt_data(y = aggression$poly,
                       ii = aggression$item,
                       jj = aggression$person)

# Add a latent regression and use labelled_integer() with the items
agg_list_2 <- irt_data(y = aggression$poly,
                       ii = labelled_integer(aggression$description),
                       jj = aggression$person,
                       covariates = aggression[, c("male", "anger")],
                       formula = ~ 1 + male*anger)
}
\seealso{
See \code{\link{labelled_integer}} for a means of creating
appropriate inputs for \code{ii} and \code{jj}.
See \code{\link{irt_stan}} to fit a model to the data list.
}

