% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting_functions.R
\name{print_irt_stan}
\alias{print_irt_stan}
\title{View a table of selected parameter posteriors after using \code{irt_stan}}
\usage{
print_irt_stan(fit, data_list = NULL, ...)
}
\arguments{
\item{fit}{A \code{stanfit-class} object created by \code{\link{irt_stan}}.}

\item{data_list}{An optional Stan data list created with
\code{\link{irt_data}}. If provided, the printed posterior summaries for
selected parameters are grouped by item. Otherwise, ungrouped results are
provided, which may be preferred, for example, for the Rasch or rating
scale models.}

\item{...}{Additional options passed to \code{\link[base]{print}}.}
}
\description{
View a table of selected parameter posteriors after using \code{irt_stan}
}
\examples{
# Make a suitable data list:
spelling_list <- irt_data(response_matrix = spelling[, 2:5],
                          covariates = spelling[, "male", drop = FALSE],
                          formula = ~ 1 + male)

\dontrun{
# Fit a latent regression  2PL
twopl_fit <- irt_stan(spelling_list, model = "2pl_latent_reg.stan",
                      iter = 300, chains = 4)

# Get a table of parameter posteriors
print_irt_stan(twopl_fit, spelling_list)
# Or
print_irt_stan(twopl_fit)
}
}

