% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_power0.R
\name{density_plot}
\alias{density_plot}
\alias{densityplot}
\title{Power curves for different sampling efforts}
\usage{
density_plot(results, powr, m = NULL, n, method, cVar, model, completePlot)
}
\arguments{
\item{results}{Part of the object of class "ecocbo_beta" that results from
\code{\link[=sim_beta]{sim_beta()}}.}

\item{powr}{Part of the object of class "ecocbo_beta" that results from
\code{\link[=sim_beta]{sim_beta()}}.}

\item{m}{Calculated in \code{\link[=plot_power]{plot_power()}}. When using the \code{single.factor} model,
m is \code{NULL}.}

\item{n}{Calculated in \code{\link[=plot_power]{plot_power()}}.}

\item{method}{Which plot is to be drawn? It is used to omit the text label when
the user selects \code{both} as method.}

\item{cVar}{Calculated variation components.}

\item{model}{Model used for calculating power. Options, so far, are
'single.factor' and 'nested.symmetric'.}

\item{completePlot}{Logical. Is the plot to be drawn complete? If FALSE the plot will
be trimmed to present a better distribution of the density plot.}
}
\value{
A density plot for the observed pseudoF values and a line marking
the value of pseudoF that marks the significance level indicated in \code{\link[=sim_beta]{sim_beta()}}.

The value of the selected 'm', 'n' and the corresponding component of variation
are presented in all methods.
}
\description{
\code{plot_power()} can be used to visualize the power of a study as a
function of the sampling effort. The power curve plot shows that the
power of the study increases as the sample size increases, and the density
plot shows the overlapping areas where \eqn{\alpha} and \eqn{\beta} are
significant.
}
\references{
Underwood, A. J. (1997). Experiments in ecology: their logical
design and interpretation using analysis of variance. Cambridge university
press.

Underwood, A. J., & Chapman, M. G. (2003). Power, precaution,
Type II error and sampling design in assessment of environmental impacts.
Journal of Experimental Marine Biology and Ecology, 296(1), 49-70.
}
\seealso{
\code{\link[=sim_beta]{sim_beta()}}
\code{\link[=scompvar]{scompvar()}}
\code{\link[=sim_cbo]{sim_cbo()}}
\code{\link[=prep_data]{prep_data()}}
\code{\link[=plot_power]{plot_power()}}
}
\author{
Edlin Guerra-Castro (\email{edlinguerra@gmail.com}), Arturo Sanchez-Porras
}
\keyword{internal}
