% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecd-cdf-method.R
\name{ecd.cdf}
\alias{ecd.cdf}
\title{CDF of ecd}
\usage{
ecd.cdf(
  object,
  x,
  from.x = -Inf,
  piece.wise = FALSE,
  f = NULL,
  verbose = FALSE
)
}
\arguments{
\item{object}{An object of ecd class}

\item{x}{A numeric vector of \code{x}}

\item{from.x}{A value or a vector of starting \code{x}, default \code{-Inf}}

\item{piece.wise}{Logical. If \code{TRUE}, use cumulative method for large array.
Default to FALSE.
Use it with a scalar \code{from.x}.}

\item{f}{an optional extension to perform integral on function other than 1.
This is for internal use only. You should use the respective wrappers.}

\item{verbose}{logical, display timing information, for debugging purpose.}
}
\value{
The CDF
}
\description{
CDF of ecd, integration of PDF from \code{-Inf} (or a point of choice) to \code{x}
}
\examples{
d <- ecd()
x <- seq(-10, 10, by=1)
ecd.cdf(d,x)
ecd.cdf(d,1, from.x = -1)
}
\author{
Stephen H. Lihn
}
\keyword{cdf}
