% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecd-stats-method.R
\name{ecd.stats}
\alias{ecd.stats}
\title{Compute statistics of an ecd object}
\usage{
ecd.stats(object, asymp.q = NULL, verbose = FALSE)
}
\arguments{
\item{object}{an object of ecd class}

\item{asymp.q}{If specified, a length-one numeric as asymptotic quantile
for the asymptotic statistics. There is a wrapper in \code{\link{ecd.asymp_stats}}}

\item{verbose}{logical, display timing information, for debugging purpose.}
}
\value{
a list of m1, m2, m3, m4, mean, var, skewness, kurtosis
}
\description{
Compute statistics for m1, m2, m3, m4, mean, var, skewness, kurtosis.
This is used as part of ecd constructor.
}
\examples{
d <- ecd(1,1)
ecd.stats(d)
}
\author{
Stephen H. Lihn
}
\keyword{statistics}
