% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sld-class.R
\docType{class}
\name{sld-class}
\alias{sld-class}
\title{An S4 class to represent the stable lambda distribution}
\description{
The \code{sld} class serves as an object-oriented interface for the stable lambda distribution.
The \code{sld} prefix is also used as the namespace for the related analytic formulae
derived in stable lambda distribution.
}
\section{Slots}{

\describe{
\item{\code{call}}{the match.call slot}

\item{\code{t}}{numeric}

\item{\code{nu0}}{numeric}

\item{\code{theta}}{numeric}

\item{\code{convo}}{numeric}

\item{\code{beta.a}}{numeric}

\item{\code{mu}}{numeric}

\item{\code{lambda}}{numeric, this is default to 4.}
}}

\section{Details}{

  See \code{\link{dsl}} for definition of stable lambda distribution.
}

\references{
For more detail, see Section 8.2 of
  Stephen Lihn (2017).
  \emph{A Theory of Asset Return and Volatility
  under Stable Law and Stable Lambda Distribution}.
  SSRN: 3046732, \url{https://papers.ssrn.com/sol3/papers.cfm?abstract_id=3046732}.
}
\seealso{
\code{\link{dstablecnt}} for \eqn{N_\alpha(.)},
  and \code{\link{dstdlap}} for \eqn{f_L^{(m)}(.)}.
}
\author{
Stephen H. Lihn
}
\keyword{ecld}
