% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecld.quartic-Qp-method.R
\name{ecld.quartic_Qp}
\alias{ecld.quartic_Qp}
\alias{ecld.quartic_Q}
\alias{ecld.quartic_Qp_atm_ki}
\alias{ecld.quartic_Qp_rho}
\alias{ecld.quartic_Qp_skew}
\alias{ecld.quartic_Qp_atm_skew}
\title{The ATM volatility and skew of \eqn{Q_p} in quartic model}
\usage{
ecld.quartic_Qp(object, ki)

ecld.quartic_Q(object, ki, otype)

ecld.quartic_Qp_atm_ki(object, lower = -50, upper = -1.37)

ecld.quartic_Qp_rho(object, atm_ki = NaN, lower = -50, upper = -1.37)

ecld.quartic_Qp_skew(object, ki, dki = 0.1)

ecld.quartic_Qp_atm_skew(object, dki = 0.1, lower = -50, upper = -1.37)
}
\arguments{
\item{object}{an object of ecd class}

\item{ki}{numeric, order of the moment to be computed}

\item{otype}{character, specifying option type with either c or p.}

\item{lower}{numeric, optional value to specify the lower bound of ATM root finding.
This is often needed when the smile is collapsed in the left wing.}

\item{upper}{numeric, optional value to specify the upper bound of ATM root finding
This is often needed when the smile is collapsed significantly in the right wing.}

\item{atm_ki}{numeric, if provided, take it as is without calculating again}

\item{dki}{numeric, delta of ki for calculating slope}
}
\value{
numeric
}
\description{
Compute the ATM location and ATM skew of \eqn{Q_p} in quartic model.
}
\examples{
\dontrun{
    ld <- ecld.quartic(sigma=0.001*ecd.mp1, epsilon=0, rho=0, mu_plus=0)
    ecld.quartic_Qp_atm_ki(ld, lower=-12, upper=-11)
    ecld.quartic_Qp_atm_skew(ld, lower=-12, upper=-11)
}
}
\author{
Stephen H-T. Lihn
}
\keyword{ATM}
