% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecld-class.R
\docType{class}
\name{ecld-class}
\alias{ecld-class}
\title{An S4 class to represent the lambda distribution}
\description{
The \code{ecld} class serves as an object-oriented interface for the lambda distribution. 
The \code{ecld} prefix will also be used as the namespace for many analytic formulai
derived in lambda distribution, especially when lambda = 1,2,3.
Because of the extensive use of analytic formulai and enhanced precision through
the unit distribution, MPFR is not needed in most cases. This makes option pricing
calculation in \code{ecld} much faster than its counterpart built on the more
general-purpose \code{ecd} library.
}
\section{Slots}{

\describe{
\item{\code{call}}{the match.call slot}

\item{\code{lambda}}{numeric}

\item{\code{sigma}}{numeric}

\item{\code{beta}}{numeric}

\item{\code{mu}}{numeric}

\item{\code{use.mpfr}}{logical, whether to use mpfr for ecld object. If any of the above parameters
is mpfr, then this flag is set to \code{TRUE}.}

\item{\code{is.sged}}{logical, if \code{TRUE}, interpret parameters as SGED.}

\item{\code{ecd}}{the companion object of ecd class (optional)}

\item{\code{mu_D}}{the risk-neutral drift, optional, but preferred to have value
if the object is to engage with OGF calculation.}

\item{\code{epsilon}}{the residual risk, optional as a storage for lambda transformation}

\item{\code{rho}}{the momentum shift, optional as a storage for lambda transformation}

\item{\code{ecd_RN}}{the risk-neutral companion object of ecd class (optional)}

\item{\code{status}}{numeric, bitmap recording the state of the calculation layers.
1: bare bone; 2: ecd; 4: mu_D; 8: ecd_RN}
}}

\author{
Stephen H. Lihn
}
\keyword{ecld}
