% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecd-erfq-method.R
\name{ecd.erfq}
\alias{ecd.erfq}
\alias{ecd.erfq_sum}
\title{Quartic scaled error function}
\usage{
ecd.erfq(x, sgn)

ecd.erfq_sum(x, sgn)
}
\arguments{
\item{x}{numeric}

\item{sgn}{an integer of 1 or -1}
}
\value{
The \code{mpfr} object
}
\description{
The scaled error function in quartic pricing model that encaptulates
both scaled \code{erfi} and \code{erfc} functions
into a single representation. This is used to provide an elegant expression for
the MGF and local option prices, \eqn{L_{c,p}}.
When \code{sgn=-1}, it is \eqn{\sqrt{\pi}e^{-x^2} erfi(x)}, which twice of Dawson function.
When \code{sgn=1}, it is \eqn{\sqrt{\pi}e^{x^2} erfc(x)}.
\code{ecd.erfq_sum} is the summation implementation with truncation rule set forth
in the quartic pricing model. It achieves high precision when x > 4.5.
}
\examples{
x <- ecd.erfq(c(5,10,15), 1)
y <- ecd.erfq(c(5,10,15), -1)
}
\keyword{utility}
