% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecd-constructor.R
\name{ecd}
\alias{ecd}
\title{Constructor of ecd class}
\usage{
ecd(alpha = 0, gamma = 0, sigma = 1, beta = 0, mu = 0, cusp = 0,
  lambda = 3, with.stats = TRUE, with.quantile = FALSE,
  bare.bone = FALSE, verbose = FALSE)
}
\arguments{
\item{alpha}{numeric, the flatness parameter. Default: 0.}

\item{gamma}{numeric, the sharpness parameter. Default: 0.}

\item{sigma}{numeric, the scale parameter. Must be positive. Default: 1.}

\item{beta}{numeric, the skewness parameter. Default: 0.}

\item{mu}{numeric, the location parameter. Default: 0.}

\item{cusp}{logical, indicate type of cusp. The singular points in cusp 
requires special handling.
Default: 0, not a cusp.
1: cusp with alpha specified.
2: cusp with gamma specified.}

\item{lambda}{numeric, the leading exponent for the special model. Default: 3.}

\item{with.stats}{logical, also calculate statistics, default is \code{TRUE}.}

\item{with.quantile}{logical, also calculate quantile data, default is \code{FALSE}.}

\item{bare.bone}{logical, skip both const and stats calculation, default is \code{FALSE}.
This for debug purpose for issues on integrating \eqn{e^y(x)}.}

\item{verbose}{logical, display timing information, for debugging purpose, default is \code{FALSE}.}
}
\value{
An object of ecd class
}
\description{
Construct an ecd class by providing the required parameters.
The default is the standard cusp distribution. 
Cusp is validated by \code{eps = max(.Machine$double.eps*1000, 1e-28)}.
}
\examples{
d <- ecd()
d <- ecd(1,1)
d <- ecd(alpha=1, gamma=1)
}
\author{
Stephen H. Lihn
}
\keyword{constructor}

