% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecld-ogf-star-method.R
\name{ecld.ogf_star}
\alias{ecld.ogf_star}
\alias{ecld.ogf_star_exp}
\alias{ecld.ogf_star_gamma_star}
\alias{ecld.ogf_star_hgeo}
\title{Star OGF of ecld}
\usage{
ecld.ogf_star(object, ki)

ecld.ogf_star_hgeo(object, ki, order = 4)

ecld.ogf_star_exp(object, ki, order = 3)

ecld.ogf_star_gamma_star(object, ki, order = 6)
}
\arguments{
\item{object}{an object of ecld class}

\item{ki}{a numeric vector of log-strike}

\item{order}{numeric, order of the hypergeometric series to be computed}
}
\value{
The state price of option in star OGF terms.
}
\description{
The star OGF of ecld is the limiting OGF for small sigma.
It only depends on the normalized k and lambda.
Its dependency on sigma and mu is removed.
SGED is not supported yet.
}
\examples{
ld <- ecld(sigma=0.001*ecd.mp1)
ki <- seq(1, 5, by=1)
ecld.ogf_star(ld, ki)
}
\author{
Stephen H-T. Lihn
}
\keyword{ogf}

