% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecld-gamma-method.R
\name{ecld.gamma}
\alias{ecld.gamma}
\alias{ecld.gamma_2F0}
\alias{ecld.gamma_hgeo}
\title{Incomplete gamma function and asymptotic expansion}
\usage{
ecld.gamma(s, x = 0)

ecld.gamma_hgeo(s, x, order)

ecld.gamma_2F0(s, x, order)
}
\arguments{
\item{s}{numeric}

\item{x}{numeric}

\item{order}{numeric, the order of the power series}
}
\value{
numeric
}
\description{
\code{ecld.gamma} is the wrapper for incomplete gamma function
\eqn{\Gamma(s,x)}. It is mainly to wrap around \code{pgamma}.
And \code{ecld.gamma_hgeo} is the asymptotic expansion of \eqn{\Gamma(s,x)}
using hypergeometric series, \eqn{e^{-x} x^{s-1} {}_2 F_0 (1,1-s;;-1/x)}.
It is mainly used in for star OGF \eqn{L^{*}(k;\lambda)}.
\code{ecld.gamma_2F0} is simply \eqn{{}_2 F_0 (1,1-s;;-1/x)}, which is used
in the star OGF expansion.
}
\author{
Stephen H-T. Lihn
}
\keyword{gamma}

