% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edl_s3_token.R
\name{edl_s3_token}
\alias{edl_s3_token}
\title{Receive and set temporary AWS Tokens for S3 access}
\usage{
edl_s3_token(
  daac = "https://data.lpdaac.earthdatacloud.nasa.gov",
  username = default("user"),
  password = default("password"),
  prompt_for_netrc = interactive()
)
}
\arguments{
\item{daac}{the base URL for the DAAC}

\item{username}{EarthDataLogin user}

\item{password}{EarthDataLogin Password}

\item{prompt_for_netrc}{Often netrc is preferable, so this function will by
default prompt the user to switch.  Set to FALSE to silence this.}
}
\value{
list of access key, secret key, session token and expiration,
invisibly.  Also sets the corresponding AWS environmental variables.
}
\description{
Note that these S3 credentials will only work:
}
\details{
\itemize{
\item On AWS instance in the \code{us-west-2} region
\item Only for one hour before they expire
\item Only on the DAAC requested
}

Please consider using \code{\link[=edl_netrc]{edl_netrc()}} to avoid these limitations
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
edl_s3_token()
\dontshow{\}) # examplesIf}
}
