% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sql.R
\name{default_conn}
\alias{default_conn}
\title{Get the default connection}
\usage{
default_conn()
}
\value{
A DuckDB connection object
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{default_conn()} returns a default, built-in connection.
}
\details{
Currently, the connection is established with \code{duckdb(environment_scan = TRUE)}
and \code{dbConnect(timezone_out = "", array = "matrix")}
so that data frames are automatically available as tables,
timestamps are returned in the local timezone,
and DuckDB's array type is returned as an R matrix.
The details of how the connection is established are subject to change.
In particular, returning the output as a tibble or other object may be supported
in the future.

This connection is intended for interactive use.
There is no way for this or other packages to comprehensively track the state
of this connection, so scripts and packages should manage their own connections.
}
\examples{
conn <- default_conn()
sql_query("SELECT 42", conn = conn)
}
