% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary-table.R
\name{summary_table_by}
\alias{summary_table_by}
\title{Create a summary table using multiple rows for grouping on one target column}
\usage{
summary_table_by(
  dt,
  target,
  treat,
  rows_by,
  indent = nbsp(n = 4L),
  .total_dt = dt,
  pct_dec = 1,
  treat_order = NULL,
  skip_absent = TRUE
)
}
\arguments{
\item{dt}{A \code{data.frame} containing, at least, the variables indicated in
\code{target} and \code{treat}.}

\item{target}{Target variable passed as a string for which summary
statistics are to be calculated.}

\item{treat}{A string indicating the grouping variable, e.g. the variable
specifying the treatment population.}

\item{rows_by}{string, grouping variable to split events by.}

\item{indent}{A string to be used as indentation of summary statistics
labels. Defaults to four HTML non-breaking spaces (\verb{&nbsp;}).}

\item{.total_dt}{Separate table from \code{dt} from which to derive total counts
per group.}

\item{pct_dec}{Decimal places for reported figures.}

\item{treat_order}{Customise the column order of the output table.}

\item{skip_absent}{Whether to ignore variables passed in \code{treat_order} that
are absent from \code{dt}. Default is \code{TRUE}; \code{FALSE} will throw an error in
case there are missing variables.}
}
\value{
The same output as \code{\link[=summary_table]{summary_table()}} except that folded by variables
indicated in \code{rows_by}.
}
\description{
Create a summary table using multiple rows for grouping on one target column
}
\examples{
summary_table_by(adlb, target = "AVAL", treat = "ARM", rows_by = c("PARAM","AVISIT"))

}
