% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/word.R
\name{word_probability}
\alias{word_probability}
\title{Probability of a word at a position t of a DMM}
\usage{
word_probability(word, pos, x, output_file = NULL, internal = FALSE, ncpu = 2)
}
\arguments{
\item{word}{A subsequence (string of characters)}

\item{pos}{A position (numeric)}

\item{x}{An object of class \code{dmm}}

\item{output_file}{(Optional) A file containing the probability (e.g,"C:/.../PROB.txt")}

\item{internal}{\code{FALSE} (default) ; \code{TRUE} (for internal use of word applications)}

\item{ncpu}{Default=2. Represents the number of cores used to parallelized computation. If ncpu=-1, then it uses all available cores.}
}
\value{
A numeric, probability of \code{word}
}
\description{
Probability of a word at a position t of a DMM
}
\examples{
data(lambda, package = "drimmR")
dmm <- fitdmm(lambda, 1, 1, c('a','c','g','t'), init.estim = "freq", fit.method="sum")
word_probability("aggctga",4,dmm)
}
\references{
\insertRef{BaVe2018}{drimmR}
\insertRef{Ver08}{drimmR}
}
\seealso{
\link[drimmR]{fitdmm}, \link[drimmR]{getTransitionMatrix}, \link[drimmR]{word_probabilities}, \link[drimmR]{words_probabilities}
}
\author{
Victor Mataigne, Alexandre Seiller
}
