% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/available_sections.R
\name{available_sections}
\alias{available_sections}
\title{List of available sections for \code{dawa()}}
\usage{
available_sections(as_list = FALSE, format = NULL, verbose = TRUE, func = NULL)
}
\arguments{
\item{as_list}{This options controls the output format. The output is either
a named list or an atomic vector with the available sections}

\item{format}{Specify a format type. The function now returns only available
sections that can respond with that format. Currently \code{geojson} is the only
format that is specified.}

\item{verbose}{whether or not to provide \code{{cli}} output for the user. Enabled
by default, but disabled for all functions that wrap this function}

\item{func}{Sepcify the function you would like to ensure section
compatability with.}
}
\value{
The function returns either a named list or an atomic vector with the
available sections in the API. The format is decided by \code{as_list}.
}
\description{
Simple function to list all available options for the \code{section}
parameter in \code{dawa()}. Useful when getting to know the base api function of
this package. To filter based on funciton usage you can provide \code{format = "geojson"} to ensure compatability with \code{get_map_data()} and \code{func = "get_data"} to ensure compatability with \code{get_data()}.
}
\examples{

available_sections()

available_sections(as_list = TRUE)

}
