% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/out_saveReport.R
\name{saveReport}
\alias{saveReport}
\title{Save a report based on a dataCompareR object}
\usage{
saveReport(compareObject, reportName, reportLocation = ".",
  HTMLReport = TRUE, showInViewer = TRUE, stylesheet = NA)
}
\arguments{
\item{compareObject}{a dataCompareR object.}

\item{reportName}{String. The name of the report. Reports will be saved as reportName.Rmd and (optionally) reportName.html in 
\code{reportLocation}}

\item{reportLocation}{String. Location to save reports specified by the user. The R markdown and (optionally) HTML reports will 
be saved in this area}

\item{HTMLReport}{Boolean. Option to output html report.}

\item{showInViewer}{Boolean. Does the html report open automatically in the viewer?}

\item{stylesheet}{String. Optional link to customised css stylesheet}
}
\description{
Saves R markdown and HTML reports in the area specified by the user. 

Uses knitr and markdown to create reports. Reports have the extensions .Rmd or .html. 
By default the \code{table.css} style sheet is used for format the html output.
}
\examples{
 
\dontrun{saveReport(rcObj, reportName = 'testReport')}
}
\seealso{
Other dataCompareR.functions: \code{\link{generateMismatchData}},
  \code{\link{print.dataCompareRobject}},
  \code{\link{rCompare}},
  \code{\link{summary.dataCompareRobject}}
}
