% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateLogo_shinyDashboardLogo.R
\name{shinyDashboardLogo}
\alias{shinyDashboardLogo}
\title{shinyDashboardLogo}
\usage{
shinyDashboardLogo(
  theme,
  boldText = "Shiny",
  mainText = "App",
  badgeText = "v1.1"
)
}
\arguments{
\item{theme}{String. Name of theme to be used}

\item{boldText}{String. Bold text for the logo.}

\item{mainText}{String. Main text for the logo.}

\item{badgeText}{String. Text for the logo badge.}
}
\value{
HTML code. Logo for shinydashboard's sidebar.
}
\description{
Calls a custom logo object created using shinyDashboardLogoDIY
}
\note{
This logo design was inspired from \url{http://www.dataseries.org/}.
}
\examples{
\donttest{
#...
### ui
#ui <- dashboardPage(

  ### ui header
  #dashboardHeader(

    ### changing logo
    title = shinyDashboardLogo(
      theme = "blue_gradient",
      boldText = "Shiny",
      mainText = "App",
      badgeText = "v1.1"
    )
    #...
}
}
\seealso{
\code{\link{shinyDashboardLogoDIY}, \link{shinyDashboardThemes}}
}
