% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/racusum_alpha_sim.R
\name{racusum_alpha_sim}
\alias{racusum_alpha_sim}
\title{Simulate false signal probability alpha given control limit for RA-CUSUM charts}
\usage{
racusum_alpha_sim(patient_risks, odds_multiplier, n_simulation, limit,
  seed = NULL)
}
\arguments{
\item{patient_risks}{A vector containing patient risk scores}

\item{odds_multiplier}{Odds multiplier for the alternative hypothesis (<1 looks for decreases)}

\item{n_simulation}{Number of simulations}

\item{limit}{Control limit to signal process deterioration}

\item{seed}{An optional seed for simulation}
}
\value{
Returns false signal probability
}
\description{
Simulate false signal probability alpha given control limit for RA-CUSUM charts
}
\examples{

# Patients risks are usually known from Phase I.
# If not, these risk scores can be simulated.

# define possible patient risk scores
risks <- c(0.001, 0.01, 0.1, 0.002, 0.02, 0.2)

# sample risk population of size n = 100
set.seed(2046)
patient_risks <- sample(x = risks, size = 100, replace = TRUE)

# control limit can be obtained with racusum_limit_sim(),
# here it is set to an arbitrary value (2.96)

# simulate false positive probability of RA-CUSUM
racusum_alpha_sim(patient_risks,
  odds_multiplier = 2,
  n_simulation = 1000,
  limit = 2.96,
  seed = 2046
)
}
