% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cusum_alpha_sim.R
\name{cusum_alpha_sim}
\alias{cusum_alpha_sim}
\title{Simulate false signal probability alpha given control limit for CUSUM charts}
\usage{
cusum_alpha_sim(failure_probability, n_patients, odds_multiplier,
  n_simulation, limit, seed = NULL)
}
\arguments{
\item{failure_probability}{Accepted failure probability of process}

\item{n_patients}{Sample size}

\item{odds_multiplier}{Odds multiplier for the alternative hypothesis (<1 looks for decreases)}

\item{n_simulation}{Number of simulations}

\item{limit}{Control limit to signal process deterioration}

\item{seed}{An optional seed for simulation}
}
\value{
Returns false signal probability alpha
}
\description{
Simulate false signal probability alpha given control limit for CUSUM charts
}
\examples{

#
# control limit can be obtained with cusum_limit_sim(),
# here it is set to an arbitrary value (2.96)

# simulate false positive probability of CUSUM
cusum_alpha_sim(
  failure_probability = 0.05,
  n_patients = 100,
  odds_multiplier = 2,
  n_simulation = 10000,
  limit = 2.96,
  seed = 2046
)
}
