% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xmap.R
\name{xmap}
\alias{xmap}
\alias{xmap_chr}
\alias{xmap_dbl}
\alias{xmap_dfc}
\alias{xmap_dfr}
\alias{xmap_int}
\alias{xmap_lgl}
\alias{xmap_raw}
\alias{xwalk}
\title{Map over each combination of list elements}
\usage{
xmap(.l, .f, ...)

xmap_chr(.l, .f, ...)

xmap_dbl(.l, .f, ...)

xmap_dfc(.l, .f, ...)

xmap_dfr(.l, .f, ..., .id = NULL)

xmap_int(.l, .f, ...)

xmap_lgl(.l, .f, ...)

xmap_raw(.l, .f, ...)

xwalk(.l, .f, ...)
}
\arguments{
\item{.l}{A list of vectors, such as a data frame.
The length of .l determines the number of arguments that .f will be called
with.
List names will be used if present.}

\item{.f}{A function, formula, or vector (not necessarily atomic).

If a \strong{function}, it is used as is.

If a \strong{formula}, e.g. \code{~ .x + 2}, it is converted to a function. There
are three ways to refer to the arguments:
\itemize{
\item For a single argument function, use \code{.}
\item For a two argument function, use \code{.x} and \code{.y}
\item For more arguments, use \code{..1}, \code{..2}, \code{..3} etc
}

This syntax allows you to create very compact anonymous functions.

If \strong{character vector}, \strong{numeric vector}, or \strong{list}, it is
converted to an extractor function. Character vectors index by
name and numeric vectors index by position; use a list to index
by position and name at different levels. If a component is not
present, the value of \code{.default} will be returned.}

\item{...}{Additional arguments passed on to \code{.f}}

\item{.id}{Either a string or \code{NULL}.
If a string, the output will contain a variable with that name, storing
either the name (if \code{.x} is named) or the index (if \code{.x} is unnamed) of
the input.
If \code{NULL}, the default, no variable will be created.

Only applies to \verb{_dfr} variant.}
}
\value{
An atomic vector, list, or data frame, depending on the suffix.
Atomic vectors and lists will be named if the first element of .l is named.

If all input is length 0, the output will be length 0.
If any input is length 1, it will be recycled to the length of the longest.
}
\description{
These functions are variants of \code{\link[purrr:pmap]{purrr::pmap()}} that iterate over each
combination of elements in a list.
}
\details{
Typed variants return a vector of the specified type.
To automatically determine type, try \code{\link[=xmap_vec]{xmap_vec()}}.

To return results as a matrix or array, try \code{\link[=xmap_mat]{xmap_mat()}} and \code{\link[=xmap_arr]{xmap_arr()}}.

Note that a data frame is a very important special case, in which case
\code{xmap()} and \code{xwalk()} apply the function \code{.f} to each row.
\code{xmap_dfr()} and \code{xmap_dfc()} return data frames created by row-binding and
column-binding respectively.
}
\examples{
xmap(list(1:5, 1:5), ~ .y * .x)
xmap_dbl(list(1:5, 1:5), ~ .y * .x)
xmap_chr(list(1:5, 1:5), ~ paste(.y, "*", .x, "=", .y * .x))

apples_and_bananas <- list(
  x = c("apples", "bananas"),
  pattern = "a",
  replacement = c("oo", "ee")
)

xmap_chr(apples_and_bananas, gsub)

formulas <- list(mpg ~ wt, mpg ~ hp)
subsets  <- split(mtcars, mtcars$cyl)

xmap(list(subsets, formulas), ~ lm(.y, data = .x))
xmap(list(data = subsets, formula = formulas), lm)
}
\seealso{
\code{\link[=xmap_vec]{xmap_vec()}} to automatically determine output type.

\code{\link[=xmap_mat]{xmap_mat()}} and \code{\link[=xmap_arr]{xmap_arr()}} to return results in a matrix or array.

\code{\link[=future_xmap]{future_xmap()}} to run \code{xmap} functions with parallel processing.

\code{\link[=cross_fit]{cross_fit()}} to apply multiple models to multiple subsets of data.

\code{\link[=cross_list]{cross_list()}} to find combinations of list elements.

\code{\link[purrr:map]{purrr::map()}}, \code{\link[purrr:map2]{purrr::map2()}}, and \code{\link[purrr:pmap]{purrr::pmap()}} for other mapping
functions.
}
