% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_glance.R
\name{tidy_glance}
\alias{tidy_glance}
\title{Turn an object into a tidy tibble with glance information}
\usage{
tidy_glance(x, ..., tidy_args = list(), glance_args = list())
}
\arguments{
\item{x}{An object to be converted into a tidy \link[tibble:tibble]{tibble}.}

\item{...}{Additional arguments passed to \code{\link[generics:tidy]{generics::tidy()}}
and \code{\link[generics:glance]{generics::glance()}}.

Arguments are passed to both methods, but should be ignored by the
inapplicable method. For example, if called on an \link[stats:lm]{lm} object,
\code{conf.int} will affect \code{\link[generics:tidy]{generics::tidy()}} but not \code{\link[generics:glance]{generics::glance()}}.}

\item{tidy_args}{A list of additional arguments passed only
to \code{\link[generics:tidy]{generics::tidy()}}.}

\item{glance_args}{A list of additional arguments passed only
to \code{\link[generics:glance]{generics::glance()}}.}
}
\value{
A \link[tibble:tibble]{tibble} with columns and rows from
\code{\link[generics:tidy]{generics::tidy()}} and columns of repeated rows
from \code{\link[generics:glance]{generics::glance()}}.

Column names that appear in both the \code{tidy} data and \code{glance} data will be
disambiguated by appending "\code{model.}" to the \code{glance} column names.
}
\description{
Apply both \code{\link[generics:tidy]{generics::tidy()}} and \code{\link[generics:glance]{generics::glance()}} to an object and
return a single \link[tibble:tibble]{tibble} with both sets of information.
}
\examples{
mod <- lm(mpg ~ wt + qsec, data = mtcars)
tidy_glance(mod)
tidy_glance(mod, conf.int = TRUE)
tidy_glance(mod, tidy_args = list(conf.int = TRUE))
}
