% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross_fit.R
\name{cross_fit}
\alias{cross_fit}
\title{Cross map a model across multiple formulas, subsets, and weights}
\usage{
cross_fit(
  data,
  formulas,
  cols = NULL,
  weights = NULL,
  fn = stats::lm,
  fn_args = list(),
  tidy = tidy_glance,
  tidy_args = list(),
  errors = c("stop", "warn")
)
}
\arguments{
\item{data}{A data frame}

\item{formulas}{A list of formulas to apply to each subset of the data.
If named, these names will be used in the \code{model} column of the output.
Otherwise, the formulas will be converted to strings in the \code{model} column.}

\item{cols}{Columns to subset the data.
Can be any expression supported by
<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}>.
If \code{\link{NULL}}, the data is not subset into columns.
Defaults to \code{NULL}.}

\item{weights}{A list of columns passed to \code{weights} in \code{fn}.
If one of the elements is \code{\link{NULL}} or \code{\link{NA}}, that model will not
be weighted.
Defaults to \code{NULL}.}

\item{fn}{The modeling function.
Either an unquoted function name or a \link[purrr:map]{purrr}-style lambda
function with two arguments.
To use multiple modeling functions, see \code{\link[=cross_fit_glm]{cross_fit_glm()}}.
Defaults to \link[stats:lm]{lm}.}

\item{fn_args}{A list of additional arguments to \code{fn}.}

\item{tidy}{A logical or function to use to tidy model output into
data.frame columns.
If \code{TRUE}, uses the default tidying function: \code{\link[=tidy_glance]{tidy_glance()}}.
If \code{FALSE}, \code{NA}, or \code{NULL}, the untidied model output will be returned in
a list column named \code{fit}.
An alternative function can be specified with an unquoted function name or
a \link[purrr:map]{purrr}-style lambda function with one argument (see usage
with \link[broom:reexports]{broom::tidy(conf.int = TRUE)} in examples).
Defaults to \link{tidy_glance}.}

\item{tidy_args}{A list of additional arguments to the \code{tidy} function}

\item{errors}{If \code{"stop"}, the default, the function will stop and return an
error if any subset produces an error.
If \code{"warn"}, the function will produce a warning for subsets that produce
an error and return results for all subsets that do not.}
}
\value{
A tibble with subsetting columns,
a column for the model formula applied,
a column for the weights applied (if applicable),
and columns of tidy model output or a list column of models
(if \code{tidy = FALSE})
}
\description{
Applies a modeling function to every combination of a set of formulas and a
set of data subsets.
}
\examples{
cross_fit(mtcars, mpg ~ wt, cyl)
cross_fit(mtcars, list(mpg ~ wt, mpg ~ hp), cyl)
cross_fit(mtcars, list(wt = mpg ~ wt, hp = mpg ~ hp), cyl)

cross_fit(mtcars, list(mpg ~ wt, mpg ~ hp), c(cyl, vs))
cross_fit(mtcars, list(mpg ~ wt, mpg ~ hp), dplyr::starts_with("c"))

cross_fit(mtcars, list(hp = mpg ~ hp), cyl, weights = wt)
cross_fit(mtcars, list(hp = mpg ~ hp), cyl, weights = c(wt, NA))

cross_fit(
  mtcars, list(vs ~ cyl, vs ~ hp), am,
  fn = glm, fn_args = list(family = binomial(link = logit))
)
cross_fit(
  mtcars, list(vs ~ cyl, vs ~ hp), am,
  fn = ~ glm(.x, .y, family = binomial(link = logit))
)

cross_fit(mtcars, list(mpg ~ wt, mpg ~ hp), cyl, tidy = FALSE)
cross_fit(mtcars, list(mpg ~ wt, mpg ~ hp), cyl, tidy_args = c(conf.int = TRUE))

cross_fit(mtcars, list(mpg ~ wt, mpg ~ hp), cyl, tidy = broom::tidy)
cross_fit(
  mtcars, list(mpg ~ wt, mpg ~ hp), cyl,
  tidy = ~ broom::tidy(., conf.int = TRUE)
)
}
\seealso{
\code{\link[=cross_fit_glm]{cross_fit_glm()}} to map a model across multiple model types.

\code{\link[=xmap]{xmap()}} to apply any function to combinations of inputs.
}
