% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autonames.R
\name{autonames}
\alias{autonames}
\title{Automatically generate names for vectors}
\usage{
autonames(x, ..., trimws = getRversion() > numeric_version("3.3.0"))
}
\arguments{
\item{x}{A vector}

\item{...}{Additional arguments passed to \code{\link[=format]{format()}}}

\item{trimws}{Whether to trim whitespace surrounding automatically formatted
names.
Requires R version 3.3.0 or greater.
Defaults to \code{TRUE} if R version is 3.3.0 or greater.}
}
\value{
Returns the names of a named vector and the elements of an unnamed
vector formatted as characters.
}
\description{
Automatically generate names for vectors
}
\examples{
autonames(c(a = "apple", b = "banana", c = "cantaloupe"))
autonames(c("apple", "banana", "cantaloupe"))

autonames(10^(1:4))
autonames(10^(1:4), big.mark = ",")
autonames(10^(1:4), scientific = TRUE)
}
