% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contains.R
\name{contains}
\alias{contains}
\alias{contains,CppSet-method}
\alias{contains,CppUnorderedSet-method}
\alias{contains,CppMultiset-method}
\alias{contains,CppUnorderedMultiset-method}
\alias{contains,CppMap-method}
\alias{contains,CppUnorderedMap-method}
\alias{contains,CppMultimap-method}
\alias{contains,CppUnorderedMultimap-method}
\title{Check for elements}
\usage{
contains(x, values)
}
\arguments{
\item{x}{A CppSet, CppUnorderedSet, CppMultiset, CppUnorderedMultiset, CppMap, CppUnorderedMap, CppMultimap, or CppUnorderedMultimap object.}

\item{values}{Values whose existence to assess. Refers to keys in the case of CppMap, CppUnorderedMap, CppMultimap, and CppUnorderedMultimap objects.}
}
\value{
Returns a logical vector of the same length as \code{values}, denoting for each value whether it is part of \code{x} (\code{TRUE}) or not 
(\code{FALSE}).
}
\description{
Check, if elements are part of a container.
}
\examples{
s <- cpp_multiset(4:9)
s
# 4 5 6 7 8 9

contains(s, 9:11)
# [1]  TRUE FALSE FALSE

m <- cpp_unordered_map(c("hello", "world"), 3:4)
m
# ["world",4] ["hello",3]

contains(m, c("world", "there"))
# [1]  TRUE FALSE

}
\seealso{
\link{[}, \link{at}, \link{back}, \link{front}, \link{top}.
}
