# set
testthat::test_that("set print integer", {
  v <- cpp_set(4:6)
  testthat::expect_output(print(v), "4 5 6")
  testthat::expect_output(print(v, n = 2), "4 5")
  testthat::expect_output(print(v, n = -2), "6 5")
  testthat::expect_output(print(v, from = 6), "6")
  testthat::expect_output(print(v, to = 4), "4")
  testthat::expect_output(print(v, from = 6, to = 6), "6")
})
testthat::test_that("set print double", {
  v <- cpp_set(seq.int(1, 2, 0.5))
  testthat::expect_output(print(v), "1 1.5 2")
  testthat::expect_output(print(v, n = 2), "1 1.5")
  testthat::expect_output(print(v, n = -2), "2 1.5")
  testthat::expect_output(print(v, from = 2), "2")
  testthat::expect_output(print(v, to = 1), "1")
  testthat::expect_output(print(v, from = 2, to = 2), "2")
})
testthat::test_that("set print string", {
  v <- cpp_set(c("hello", "there", "world"))
  testthat::expect_output(print(v), "\"hello\" \"there\" \"world\"")
  testthat::expect_output(print(v, n = 2), "\"hello\" \"there\"")
  testthat::expect_output(print(v, n = -2), "\"world\" \"there\"")
  testthat::expect_output(print(v, from = "there"), "\"there\"")
  testthat::expect_output(print(v, to = "hello"), "\"hello\"")
  testthat::expect_output(print(v, from = "there", to = "there"), "\"there\"")
})
testthat::test_that("set print boolean", {
  v <- cpp_set(c(TRUE, FALSE))
  testthat::expect_output(print(v), "FALSE TRUE")
  testthat::expect_output(print(v, n = 1), "FALSE")
  testthat::expect_output(print(v, n = -1), "TRUE")
  testthat::expect_output(print(v, from = TRUE), "TRUE")
  testthat::expect_output(print(v, to = FALSE), "FALSE")
  testthat::expect_output(print(v, from = TRUE, to = TRUE), "TRUE")
})

# unordered_set
testthat::test_that("unordered_set print integer", {
  v <- cpp_unordered_set(4:6)
  testthat::expect_output(print(v), ".{5}")
  testthat::expect_output(print(v, n = 2), ".{3}")
})
testthat::test_that("unordered_set print double", {
  v <- cpp_unordered_set(seq.int(1, 2, 0.5))
  testthat::expect_output(print(v), ".{7}")
  testthat::expect_output(print(v, n = 2), ".{5}")
})
testthat::test_that("unordered_set print string", {
  v <- cpp_unordered_set(c("hello", "there", "world"))
  testthat::expect_output(print(v), ".{24}")
  testthat::expect_output(print(v, n = 2), ".{16}")
})
testthat::test_that("unordered_set print boolean", {
  v <- cpp_unordered_set(c(TRUE, FALSE))
  testthat::expect_output(print(v), ".{11}")
  testthat::expect_output(print(v, n = 1), ".{6}")
})

# multiset
testthat::test_that("multiset print integer", {
  v <- cpp_multiset(4:6)
  testthat::expect_output(print(v), "4 5 6")
  testthat::expect_output(print(v, n = 2), "4 5")
  testthat::expect_output(print(v, n = -2), "6 5")
  testthat::expect_output(print(v, from = 6), "6")
  testthat::expect_output(print(v, to = 4), "4")
  testthat::expect_output(print(v, from = 6, to = 6), "6")
})
testthat::test_that("multiset print double", {
  v <- cpp_multiset(seq.int(1, 2, 0.5))
  testthat::expect_output(print(v), "1 1.5 2")
  testthat::expect_output(print(v, n = 2), "1 1.5")
  testthat::expect_output(print(v, n = -2), "2 1.5")
  testthat::expect_output(print(v, from = 2), "2")
  testthat::expect_output(print(v, to = 1), "1")
  testthat::expect_output(print(v, from = 2, to = 2), "2")
})
testthat::test_that("multiset print string", {
  v <- cpp_multiset(c("hello", "there", "world"))
  testthat::expect_output(print(v), "\"hello\" \"there\" \"world\"")
  testthat::expect_output(print(v, n = 2), "\"hello\" \"there\"")
  testthat::expect_output(print(v, n = -2), "\"world\" \"there\"")
  testthat::expect_output(print(v, from = "there"), "\"there\"")
  testthat::expect_output(print(v, to = "hello"), "\"hello\"")
  testthat::expect_output(print(v, from = "there", to = "there"), "\"there\"")
})
testthat::test_that("multiset print boolean", {
  v <- cpp_multiset(c(TRUE, FALSE))
  testthat::expect_output(print(v), "FALSE TRUE")
  testthat::expect_output(print(v, n = 1), "FALSE")
  testthat::expect_output(print(v, n = -1), "TRUE")
  testthat::expect_output(print(v, from = TRUE), "TRUE")
  testthat::expect_output(print(v, to = FALSE), "FALSE")
  testthat::expect_output(print(v, from = TRUE, to = TRUE), "TRUE")
})

# unordered_multiset
testthat::test_that("unordered_multiset print integer", {
  v <- cpp_unordered_multiset(4:6)
  testthat::expect_output(print(v), ".{5}")
  testthat::expect_output(print(v, n = 2), ".{3}")
})
testthat::test_that("unordered_multiset print double", {
  v <- cpp_unordered_multiset(seq.int(1, 2, 0.5))
  testthat::expect_output(print(v), ".{7}")
  testthat::expect_output(print(v, n = 2), ".{5}")
})
testthat::test_that("unordered_multiset print string", {
  v <- cpp_unordered_multiset(c("hello", "there", "world"))
  testthat::expect_output(print(v), ".{24}")
  testthat::expect_output(print(v, n = 2), ".{16}")
})
testthat::test_that("unordered_multiset print boolean", {
  v <- cpp_unordered_multiset(c(TRUE, FALSE))
  testthat::expect_output(print(v), ".{11}")
  testthat::expect_output(print(v, n = 1), ".{6}")
})

# map
testthat::test_that("map print integer integer", {
  v <- cpp_map(4:6, 8:10)
  testthat::expect_output(print(v), "\\[4,8\\] \\[5,9\\] \\[6,10\\]")
  testthat::expect_output(print(v, n = 2), "\\[4,8\\] \\[5,9\\]")
  testthat::expect_output(print(v, n = -2), "\\[6,10\\] \\[5,9\\]")
  testthat::expect_output(print(v, from = 6), "\\[6,10\\]")
  testthat::expect_output(print(v, to = 4), "\\[4,8\\]")
  testthat::expect_output(print(v, from = 6, to = 6), "\\[6,10\\]")
})
testthat::test_that("map print integer double", {
  v <- cpp_map(4:6, seq.int(1, 2, 0.5))
  testthat::expect_output(print(v), "\\[4,1\\] \\[5,1.5\\] \\[6,2\\]")
  testthat::expect_output(print(v, n = 2), "\\[4,1\\] \\[5,1.5\\]")
  testthat::expect_output(print(v, n = -2), "\\[6,2\\] \\[5,1.5\\]")
  testthat::expect_output(print(v, from = 6), "\\[6,2\\]")
  testthat::expect_output(print(v, to = 4), "\\[4,1\\]")
  testthat::expect_output(print(v, from = 6, to = 6), "\\[6,2\\]")
})
testthat::test_that("map print integer string", {
  v <- cpp_map(4:6, c("hello", "there", "world"))
  testthat::expect_output(print(v), "\\[4,\"hello\"\\] \\[5,\"there\"\\] \\[6,\"world\"\\]")
  testthat::expect_output(print(v, n = 2), "\\[4,\"hello\"\\] \\[5,\"there\"\\]")
  testthat::expect_output(print(v, n = -2), "\\[6,\"world\"\\] \\[5,\"there\"\\]")
  testthat::expect_output(print(v, from = 6), "\\[6,\"world\"\\]")
  testthat::expect_output(print(v, to = 4), "\\[4,\"hello\"\\]")
  testthat::expect_output(print(v, from = 6, to = 6), "\\[6,\"world\"\\]")
})
testthat::test_that("map print integer boolean", {
  v <- cpp_map(4:6, c(TRUE, FALSE, FALSE))
  testthat::expect_output(print(v), "\\[4,TRUE\\] \\[5,FALSE\\] \\[6,FALSE\\]")
  testthat::expect_output(print(v, n = 2), "\\[4,TRUE\\] \\[5,FALSE\\]")
  testthat::expect_output(print(v, n = -2), "\\[6,FALSE\\] \\[5,FALSE\\]")
  testthat::expect_output(print(v, from = 6), "\\[6,FALSE\\]")
  testthat::expect_output(print(v, to = 4), "\\[4,TRUE\\]")
  testthat::expect_output(print(v, from = 6, to = 6), "\\[6,FALSE\\]")
})
testthat::test_that("map print double integer", {
  v <- cpp_map(seq.int(4, 4.2, 0.1), 8:10)
  testthat::expect_output(print(v), "\\[4,8\\] \\[4.1,9\\] \\[4.2,10\\]")
  testthat::expect_output(print(v, n = 2), "\\[4,8\\] \\[4.1,9\\]")
  testthat::expect_output(print(v, n = -2), "\\[4.2,10\\] \\[4.1,9\\]")
  testthat::expect_output(print(v, from = 4.2), "\\[4.2,10\\]")
  testthat::expect_output(print(v, to = 4), "\\[4,8\\]")
  testthat::expect_output(print(v, from = 4.2, to = 4.2), "\\[4.2,10\\]")
})
testthat::test_that("map print double double", {
  v <- cpp_map(seq.int(4, 4.2, 0.1), seq.int(1, 2, 0.5))
  testthat::expect_output(print(v), "\\[4,1\\] \\[4.1,1.5\\] \\[4.2,2\\]")
  testthat::expect_output(print(v, n = 2), "\\[4,1\\] \\[4.1,1.5\\]")
  testthat::expect_output(print(v, n = -2), "\\[4.2,2\\] \\[4.1,1.5\\]")
  testthat::expect_output(print(v, from = 4.2), "\\[4.2,2\\]")
  testthat::expect_output(print(v, to = 4), "\\[4,1\\]")
  testthat::expect_output(print(v, from = 4.2, to = 4.2), "\\[4.2,2\\]")
})
testthat::test_that("map print double string", {
  v <- cpp_map(seq.int(4, 4.2, 0.1), c("hello", "there", "world"))
  testthat::expect_output(print(v), "\\[4,\"hello\"\\] \\[4.1,\"there\"\\] \\[4.2,\"world\"\\]")
  testthat::expect_output(print(v, n = 2), "\\[4,\"hello\"\\] \\[4.1,\"there\"\\]")
  testthat::expect_output(print(v, n = -2), "\\[4.2,\"world\"\\] \\[4.1,\"there\"\\]")
  testthat::expect_output(print(v, from = 4.2), "\\[4.2,\"world\"\\]")
  testthat::expect_output(print(v, to = 4), "\\[4,\"hello\"\\]")
  testthat::expect_output(print(v, from = 4.2, to = 4.2), "\\[4.2,\"world\"\\]")
})
testthat::test_that("map print double boolean", {
  v <- cpp_map(seq.int(4, 4.2, 0.1), c(TRUE, FALSE, FALSE))
  testthat::expect_output(print(v), "\\[4,TRUE\\] \\[4.1,FALSE\\] \\[4.2,FALSE\\]")
  testthat::expect_output(print(v, n = 2), "\\[4,TRUE\\] \\[4.1,FALSE\\]")
  testthat::expect_output(print(v, n = -2), "\\[4.2,FALSE\\] \\[4.1,FALSE\\]")
  testthat::expect_output(print(v, from = 4.2), "\\[4.2,FALSE\\]")
  testthat::expect_output(print(v, to = 4), "\\[4,TRUE\\]")
  testthat::expect_output(print(v, from = 4.2, to = 4.2), "\\[4.2,FALSE\\]")
})
testthat::test_that("map print string integer", {
  v <- cpp_map(c("a", "quick", "test"), 8:10)
  testthat::expect_output(print(v), "\\[\"a\",8\\] \\[\"quick\",9\\] \\[\"test\",10\\]")
  testthat::expect_output(print(v, n = 2), "\\[\"a\",8\\] \\[\"quick\",9\\]")
  testthat::expect_output(print(v, n = -2), "\\[\"test\",10\\] \\[\"quick\",9\\]")
  testthat::expect_output(print(v, from = "test"), "\\[\"test\",10\\]")
  testthat::expect_output(print(v, to = "a"), "\\[\"a\",8\\]")
  testthat::expect_output(print(v, from = "test", to = "test"), "\\[\"test\",10\\]")
})
testthat::test_that("map print string double", {
  v <- cpp_map(c("a", "quick", "test"), seq.int(1, 2, 0.5))
  testthat::expect_output(print(v), "\\[\"a\",1\\] \\[\"quick\",1.5\\] \\[\"test\",2\\]")
  testthat::expect_output(print(v, n = 2), "\\[\"a\",1\\] \\[\"quick\",1.5\\]")
  testthat::expect_output(print(v, n = -2), "\\[\"test\",2\\] \\[\"quick\",1.5\\]")
  testthat::expect_output(print(v, from = "test"), "\\[\"test\",2\\]")
  testthat::expect_output(print(v, to = "a"), "\\[\"a\",1\\]")
  testthat::expect_output(print(v, from = "test", to = "test"), "\\[\"test\",2\\]")
})
testthat::test_that("map print string string", {
  v <- cpp_map(c("a", "quick", "test"), c("hello", "there", "world"))
  testthat::expect_output(print(v), "\\[\"a\",\"hello\"\\] \\[\"quick\",\"there\"\\] \\[\"test\",\"world\"\\]")
  testthat::expect_output(print(v, n = 2), "\\[\"a\",\"hello\"\\] \\[\"quick\",\"there\"\\]")
  testthat::expect_output(print(v, n = -2), "\\[\"test\",\"world\"\\] \\[\"quick\",\"there\"\\]")
  testthat::expect_output(print(v, from = "test"), "\\[\"test\",\"world\"\\]")
  testthat::expect_output(print(v, to = "a"), "\\[\"a\",\"hello\"\\]")
  testthat::expect_output(print(v, from = "test", to = "test"), "\\[\"test\",\"world\"\\]")
})
testthat::test_that("map print string boolean", {
  v <- cpp_map(c("a", "quick", "test"), c(TRUE, FALSE, FALSE))
  testthat::expect_output(print(v), "\\[\"a\",TRUE\\] \\[\"quick\",FALSE\\] \\[\"test\",FALSE\\]")
  testthat::expect_output(print(v, n = 2), "\\[\"a\",TRUE\\] \\[\"quick\",FALSE\\]")
  testthat::expect_output(print(v, n = -2), "\\[\"test\",FALSE\\] \\[\"quick\",FALSE\\]")
  testthat::expect_output(print(v, from = "test"), "\\[\"test\",FALSE\\]")
  testthat::expect_output(print(v, to = "a"), "\\[\"a\",TRUE\\]")
  testthat::expect_output(print(v, from = "test", to = "test"), "\\[\"test\",FALSE\\]")
})
testthat::test_that("map print boolean integer", {
  v <- cpp_map(c(TRUE, FALSE), 8:9)
  testthat::expect_output(print(v), "\\[FALSE,9\\] \\[TRUE,8\\]")
  testthat::expect_output(print(v, n = 1), "\\[FALSE,9\\]")
  testthat::expect_output(print(v, n = -1), "\\[TRUE,8\\]")
  testthat::expect_output(print(v, from = TRUE), "\\[TRUE,8\\]")
  testthat::expect_output(print(v, to = FALSE), "\\[FALSE,9\\]")
  testthat::expect_output(print(v, from = TRUE, to = TRUE), "\\[TRUE,8\\]")
})
testthat::test_that("map print boolean double", {
  v <- cpp_map(c(TRUE, FALSE), seq.int(1, 1.5, 0.5))
  testthat::expect_output(print(v), "\\[FALSE,1.5\\] \\[TRUE,1\\]")
  testthat::expect_output(print(v, n = 1), "\\[FALSE,1.5\\]")
  testthat::expect_output(print(v, n = -1), "\\[TRUE,1\\]")
  testthat::expect_output(print(v, from = TRUE), "\\[TRUE,1\\]")
  testthat::expect_output(print(v, to = FALSE), "\\[FALSE,1.5\\]")
  testthat::expect_output(print(v, from = TRUE, to = TRUE), "\\[TRUE,1\\]")
})
testthat::test_that("map print boolean string", {
  v <- cpp_map(c(TRUE, FALSE), c("hello", "there"))
  testthat::expect_output(print(v), "\\[FALSE,\"there\"\\] \\[TRUE,\"hello\"\\]")
  testthat::expect_output(print(v, n = 1), "\\[FALSE,\"there\"\\]")
  testthat::expect_output(print(v, n = -1), "\\[TRUE,\"hello\"\\]")
  testthat::expect_output(print(v, from = TRUE), "\\[TRUE,\"hello\"\\]")
  testthat::expect_output(print(v, to = FALSE), "\\[FALSE,\"there\"\\]")
  testthat::expect_output(print(v, from = TRUE, to = TRUE), "\\[TRUE,\"hello\"\\]")
})
testthat::test_that("map print boolean boolean", {
  v <- cpp_map(c(TRUE, FALSE), c(TRUE, FALSE))
  testthat::expect_output(print(v), "\\[FALSE,FALSE\\] \\[TRUE,TRUE\\]")
  testthat::expect_output(print(v, n = 1), "\\[FALSE,FALSE\\]")
  testthat::expect_output(print(v, n = -1), "\\[TRUE,TRUE\\]")
  testthat::expect_output(print(v, from = TRUE), "\\[TRUE,TRUE\\]")
  testthat::expect_output(print(v, to = FALSE), "\\[FALSE,FALSE\\]")
  testthat::expect_output(print(v, from = TRUE, to = TRUE), "\\[TRUE,TRUE\\]")
})

# unordered_map
testthat::test_that("unordered_map print integer integer", {
  v <- cpp_unordered_map(4:6, 8:10)
  testthat::expect_output(print(v), ".{18}")
  testthat::expect_output(print(v, n = 2), ".{13}")
})
testthat::test_that("unordered_map print integer double", {
  v <- cpp_unordered_map(4:6, seq.int(1, 2, 0.5))
  testthat::expect_output(print(v), ".{20}")
  testthat::expect_output(print(v, n = 2), ".{14}")
})
testthat::test_that("unordered_map print integer string", {
  v <- cpp_unordered_map(4:6, c("hello", "there", "world"))
  testthat::expect_output(print(v), ".{36}")
  testthat::expect_output(print(v, n = 2), ".{24}")
})
testthat::test_that("unordered_map print integer boolean", {
  v <- cpp_unordered_map(4:6, c(TRUE, FALSE, FALSE))
  testthat::expect_output(print(v), ".{29}")
  testthat::expect_output(print(v, n = 2), ".{20}")
})
testthat::test_that("unordered_map print double integer", {
  v <- cpp_unordered_map(seq.int(4, 4.2, 0.1), 8:10)
  testthat::expect_output(print(v), ".{23}")
  testthat::expect_output(print(v, n = 2), ".{17}")
})
testthat::test_that("unordered_map print double double", {
  v <- cpp_unordered_map(seq.int(4, 4.2, 0.1), seq.int(1, 2, 0.5))
  testthat::expect_output(print(v), ".{24}")
  testthat::expect_output(print(v, n = 2), ".{18}")
})
testthat::test_that("unordered_map print double string", {
  v <- cpp_unordered_map(seq.int(4, 4.2, 0.1), c("hello", "there", "world"))
  testthat::expect_output(print(v), ".{40}")
  testthat::expect_output(print(v, n = 2), ".{28}")
})
testthat::test_that("unordered_map print double boolean", {
  v <- cpp_unordered_map(seq.int(4, 4.2, 0.1), c(TRUE, FALSE, FALSE))
  testthat::expect_output(print(v), ".{33}")
  testthat::expect_output(print(v, n = 2), ".{24}")
})
testthat::test_that("unordered_map print string integer", {
  v <- cpp_unordered_map(c("a", "quick", "test"), 8:10)
  testthat::expect_output(print(v), ".{32}")
  testthat::expect_output(print(v, n = 2), ".{24}")
})
testthat::test_that("unordered_map print string double", {
  v <- cpp_unordered_map(c("a", "quick", "test"), seq.int(1, 2, 0.5))
  testthat::expect_output(print(v), ".{33}")
  testthat::expect_output(print(v, n = 2), ".{25}")
})
testthat::test_that("unordered_map print string string", {
  v <- cpp_unordered_map(c("a", "quick", "test"), c("hello", "there", "world"))
  testthat::expect_output(print(v), ".{49}")
  testthat::expect_output(print(v, n = 2), ".{35}")
})
testthat::test_that("unordered_map print string boolean", {
  v <- cpp_unordered_map(c("a", "quick", "test"), c(TRUE, FALSE, FALSE))
  testthat::expect_output(print(v), ".{42}")
  testthat::expect_output(print(v, n = 2), ".{31}")
})
testthat::test_that("unordered_map print boolean integer", {
  v <- cpp_unordered_map(c(TRUE, FALSE), 8:9)
  testthat::expect_output(print(v), ".{19}")
  testthat::expect_output(print(v, n = 1), ".{10}")
})
testthat::test_that("unordered_map print boolean double", {
  v <- cpp_unordered_map(c(TRUE, FALSE), seq.int(1, 1.5, 0.5))
  testthat::expect_output(print(v), ".{21}")
  testthat::expect_output(print(v, n = 1), ".{12}")
})
testthat::test_that("unordered_map print boolean string", {
  v <- cpp_unordered_map(c(TRUE, FALSE), c("hello", "there"))
  testthat::expect_output(print(v), ".{31}")
  testthat::expect_output(print(v, n = 1), ".{16}")
})
testthat::test_that("unordered_map print boolean boolean", {
  v <- cpp_unordered_map(c(TRUE, FALSE), c(TRUE, FALSE))
  testthat::expect_output(print(v), ".{26}")
  testthat::expect_output(print(v, n = 1), ".{14}")
})

# multimap
testthat::test_that("multimap print integer integer", {
  v <- cpp_multimap(4:6, 8:10)
  testthat::expect_output(print(v), "\\[4,8\\] \\[5,9\\] \\[6,10\\]")
  testthat::expect_output(print(v, n = 2), "\\[4,8\\] \\[5,9\\]")
  testthat::expect_output(print(v, n = -2), "\\[6,10\\] \\[5,9\\]")
  testthat::expect_output(print(v, from = 6), "\\[6,10\\]")
  testthat::expect_output(print(v, to = 4), "\\[4,8\\]")
  testthat::expect_output(print(v, from = 6, to = 6), "\\[6,10\\]")
})
testthat::test_that("multimap print integer double", {
  v <- cpp_multimap(4:6, seq.int(1, 2, 0.5))
  testthat::expect_output(print(v), "\\[4,1\\] \\[5,1.5\\] \\[6,2\\]")
  testthat::expect_output(print(v, n = 2), "\\[4,1\\] \\[5,1.5\\]")
  testthat::expect_output(print(v, n = -2), "\\[6,2\\] \\[5,1.5\\]")
  testthat::expect_output(print(v, from = 6), "\\[6,2\\]")
  testthat::expect_output(print(v, to = 4), "\\[4,1\\]")
  testthat::expect_output(print(v, from = 6, to = 6), "\\[6,2\\]")
})
testthat::test_that("multimap print integer string", {
  v <- cpp_multimap(4:6, c("hello", "there", "world"))
  testthat::expect_output(print(v), "\\[4,\"hello\"\\] \\[5,\"there\"\\] \\[6,\"world\"\\]")
  testthat::expect_output(print(v, n = 2), "\\[4,\"hello\"\\] \\[5,\"there\"\\]")
  testthat::expect_output(print(v, n = -2), "\\[6,\"world\"\\] \\[5,\"there\"\\]")
  testthat::expect_output(print(v, from = 6), "\\[6,\"world\"\\]")
  testthat::expect_output(print(v, to = 4), "\\[4,\"hello\"\\]")
  testthat::expect_output(print(v, from = 6, to = 6), "\\[6,\"world\"\\]")
})
testthat::test_that("multimap print integer boolean", {
  v <- cpp_multimap(4:6, c(TRUE, FALSE, FALSE))
  testthat::expect_output(print(v), "\\[4,TRUE\\] \\[5,FALSE\\] \\[6,FALSE\\]")
  testthat::expect_output(print(v, n = 2), "\\[4,TRUE\\] \\[5,FALSE\\]")
  testthat::expect_output(print(v, n = -2), "\\[6,FALSE\\] \\[5,FALSE\\]")
  testthat::expect_output(print(v, from = 6), "\\[6,FALSE\\]")
  testthat::expect_output(print(v, to = 4), "\\[4,TRUE\\]")
  testthat::expect_output(print(v, from = 6, to = 6), "\\[6,FALSE\\]")
})
testthat::test_that("multimap print double integer", {
  v <- cpp_multimap(seq.int(4, 4.2, 0.1), 8:10)
  testthat::expect_output(print(v), "\\[4,8\\] \\[4.1,9\\] \\[4.2,10\\]")
  testthat::expect_output(print(v, n = 2), "\\[4,8\\] \\[4.1,9\\]")
  testthat::expect_output(print(v, n = -2), "\\[4.2,10\\] \\[4.1,9\\]")
  testthat::expect_output(print(v, from = 4.2), "\\[4.2,10\\]")
  testthat::expect_output(print(v, to = 4), "\\[4,8\\]")
  testthat::expect_output(print(v, from = 4.2, to = 4.2), "\\[4.2,10\\]")
})
testthat::test_that("multimap print double double", {
  v <- cpp_multimap(seq.int(4, 4.2, 0.1), seq.int(1, 2, 0.5))
  testthat::expect_output(print(v), "\\[4,1\\] \\[4.1,1.5\\] \\[4.2,2\\]")
  testthat::expect_output(print(v, n = 2), "\\[4,1\\] \\[4.1,1.5\\]")
  testthat::expect_output(print(v, n = -2), "\\[4.2,2\\] \\[4.1,1.5\\]")
  testthat::expect_output(print(v, from = 4.2), "\\[4.2,2\\]")
  testthat::expect_output(print(v, to = 4), "\\[4,1\\]")
  testthat::expect_output(print(v, from = 4.2, to = 4.2), "\\[4.2,2\\]")
})
testthat::test_that("multimap print double string", {
  v <- cpp_multimap(seq.int(4, 4.2, 0.1), c("hello", "there", "world"))
  testthat::expect_output(print(v), "\\[4,\"hello\"\\] \\[4.1,\"there\"\\] \\[4.2,\"world\"\\]")
  testthat::expect_output(print(v, n = 2), "\\[4,\"hello\"\\] \\[4.1,\"there\"\\]")
  testthat::expect_output(print(v, n = -2), "\\[4.2,\"world\"\\] \\[4.1,\"there\"\\]")
  testthat::expect_output(print(v, from = 4.2), "\\[4.2,\"world\"\\]")
  testthat::expect_output(print(v, to = 4), "\\[4,\"hello\"\\]")
  testthat::expect_output(print(v, from = 4.2, to = 4.2), "\\[4.2,\"world\"\\]")
})
testthat::test_that("multimap print double boolean", {
  v <- cpp_multimap(seq.int(4, 4.2, 0.1), c(TRUE, FALSE, FALSE))
  testthat::expect_output(print(v), "\\[4,TRUE\\] \\[4.1,FALSE\\] \\[4.2,FALSE\\]")
  testthat::expect_output(print(v, n = 2), "\\[4,TRUE\\] \\[4.1,FALSE\\]")
  testthat::expect_output(print(v, n = -2), "\\[4.2,FALSE\\] \\[4.1,FALSE\\]")
  testthat::expect_output(print(v, from = 4.2), "\\[4.2,FALSE\\]")
  testthat::expect_output(print(v, to = 4), "\\[4,TRUE\\]")
  testthat::expect_output(print(v, from = 4.2, to = 4.2), "\\[4.2,FALSE\\]")
})
testthat::test_that("multimap print string integer", {
  v <- cpp_multimap(c("a", "quick", "test"), 8:10)
  testthat::expect_output(print(v), "\\[\"a\",8\\] \\[\"quick\",9\\] \\[\"test\",10\\]")
  testthat::expect_output(print(v, n = 2), "\\[\"a\",8\\] \\[\"quick\",9\\]")
  testthat::expect_output(print(v, n = -2), "\\[\"test\",10\\] \\[\"quick\",9\\]")
  testthat::expect_output(print(v, from = "test"), "\\[\"test\",10\\]")
  testthat::expect_output(print(v, to = "a"), "\\[\"a\",8\\]")
  testthat::expect_output(print(v, from = "test", to = "test"), "\\[\"test\",10\\]")
})
testthat::test_that("multimap print string double", {
  v <- cpp_multimap(c("a", "quick", "test"), seq.int(1, 2, 0.5))
  testthat::expect_output(print(v), "\\[\"a\",1\\] \\[\"quick\",1.5\\] \\[\"test\",2\\]")
  testthat::expect_output(print(v, n = 2), "\\[\"a\",1\\] \\[\"quick\",1.5\\]")
  testthat::expect_output(print(v, n = -2), "\\[\"test\",2\\] \\[\"quick\",1.5\\]")
  testthat::expect_output(print(v, from = "test"), "\\[\"test\",2\\]")
  testthat::expect_output(print(v, to = "a"), "\\[\"a\",1\\]")
  testthat::expect_output(print(v, from = "test", to = "test"), "\\[\"test\",2\\]")
})
testthat::test_that("multimap print string string", {
  v <- cpp_multimap(c("a", "quick", "test"), c("hello", "there", "world"))
  testthat::expect_output(print(v), "\\[\"a\",\"hello\"\\] \\[\"quick\",\"there\"\\] \\[\"test\",\"world\"\\]")
  testthat::expect_output(print(v, n = 2), "\\[\"a\",\"hello\"\\] \\[\"quick\",\"there\"\\]")
  testthat::expect_output(print(v, n = -2), "\\[\"test\",\"world\"\\] \\[\"quick\",\"there\"\\]")
  testthat::expect_output(print(v, from = "test"), "\\[\"test\",\"world\"\\]")
  testthat::expect_output(print(v, to = "a"), "\\[\"a\",\"hello\"\\]")
  testthat::expect_output(print(v, from = "test", to = "test"), "\\[\"test\",\"world\"\\]")
})
testthat::test_that("multimap print string boolean", {
  v <- cpp_multimap(c("a", "quick", "test"), c(TRUE, FALSE, FALSE))
  testthat::expect_output(print(v), "\\[\"a\",TRUE\\] \\[\"quick\",FALSE\\] \\[\"test\",FALSE\\]")
  testthat::expect_output(print(v, n = 2), "\\[\"a\",TRUE\\] \\[\"quick\",FALSE\\]")
  testthat::expect_output(print(v, n = -2), "\\[\"test\",FALSE\\] \\[\"quick\",FALSE\\]")
  testthat::expect_output(print(v, from = "test"), "\\[\"test\",FALSE\\]")
  testthat::expect_output(print(v, to = "a"), "\\[\"a\",TRUE\\]")
  testthat::expect_output(print(v, from = "test", to = "test"), "\\[\"test\",FALSE\\]")
})
testthat::test_that("multimap print boolean integer", {
  v <- cpp_multimap(c(TRUE, FALSE), 8:9)
  testthat::expect_output(print(v), "\\[FALSE,9\\] \\[TRUE,8\\]")
  testthat::expect_output(print(v, n = 1), "\\[FALSE,9\\]")
  testthat::expect_output(print(v, n = -1), "\\[TRUE,8\\]")
  testthat::expect_output(print(v, from = TRUE), "\\[TRUE,8\\]")
  testthat::expect_output(print(v, to = FALSE), "\\[FALSE,9\\]")
  testthat::expect_output(print(v, from = TRUE, to = TRUE), "\\[TRUE,8\\]")
})
testthat::test_that("multimap print boolean double", {
  v <- cpp_multimap(c(TRUE, FALSE), seq.int(1, 1.5, 0.5))
  testthat::expect_output(print(v), "\\[FALSE,1.5\\] \\[TRUE,1\\]")
  testthat::expect_output(print(v, n = 1), "\\[FALSE,1.5\\]")
  testthat::expect_output(print(v, n = -1), "\\[TRUE,1\\]")
  testthat::expect_output(print(v, from = TRUE), "\\[TRUE,1\\]")
  testthat::expect_output(print(v, to = FALSE), "\\[FALSE,1.5\\]")
  testthat::expect_output(print(v, from = TRUE, to = TRUE), "\\[TRUE,1\\]")
})
testthat::test_that("multimap print boolean string", {
  v <- cpp_multimap(c(TRUE, FALSE), c("hello", "there"))
  testthat::expect_output(print(v), "\\[FALSE,\"there\"\\] \\[TRUE,\"hello\"\\]")
  testthat::expect_output(print(v, n = 1), "\\[FALSE,\"there\"\\]")
  testthat::expect_output(print(v, n = -1), "\\[TRUE,\"hello\"\\]")
  testthat::expect_output(print(v, from = TRUE), "\\[TRUE,\"hello\"\\]")
  testthat::expect_output(print(v, to = FALSE), "\\[FALSE,\"there\"\\]")
  testthat::expect_output(print(v, from = TRUE, to = TRUE), "\\[TRUE,\"hello\"\\]")
})
testthat::test_that("multimap print boolean boolean", {
  v <- cpp_multimap(c(TRUE, FALSE), c(TRUE, FALSE))
  testthat::expect_output(print(v), "\\[FALSE,FALSE\\] \\[TRUE,TRUE\\]")
  testthat::expect_output(print(v, n = 1), "\\[FALSE,FALSE\\]")
  testthat::expect_output(print(v, n = -1), "\\[TRUE,TRUE\\]")
  testthat::expect_output(print(v, from = TRUE), "\\[TRUE,TRUE\\]")
  testthat::expect_output(print(v, to = FALSE), "\\[FALSE,FALSE\\]")
  testthat::expect_output(print(v, from = TRUE, to = TRUE), "\\[TRUE,TRUE\\]")
})

# unordered_multimap
testthat::test_that("unordered_multimap print integer integer", {
  v <- cpp_unordered_multimap(4:6, 8:10)
  testthat::expect_output(print(v), ".{18}")
  testthat::expect_output(print(v, n = 2), ".{13}")
})
testthat::test_that("unordered_multimap print integer double", {
  v <- cpp_unordered_multimap(4:6, seq.int(1, 2, 0.5))
  testthat::expect_output(print(v), ".{20}")
  testthat::expect_output(print(v, n = 2), ".{14}")
})
testthat::test_that("unordered_multimap print integer string", {
  v <- cpp_unordered_multimap(4:6, c("hello", "there", "world"))
  testthat::expect_output(print(v), ".{36}")
  testthat::expect_output(print(v, n = 2), ".{24}")
})
testthat::test_that("unordered_multimap print integer boolean", {
  v <- cpp_unordered_multimap(4:6, c(TRUE, FALSE, FALSE))
  testthat::expect_output(print(v), ".{29}")
  testthat::expect_output(print(v, n = 2), ".{20}")
})
testthat::test_that("unordered_multimap print double integer", {
  v <- cpp_unordered_multimap(seq.int(4, 4.2, 0.1), 8:10)
  testthat::expect_output(print(v), ".{23}")
  testthat::expect_output(print(v, n = 2), ".{17}")
})
testthat::test_that("unordered_multimap print double double", {
  v <- cpp_unordered_multimap(seq.int(4, 4.2, 0.1), seq.int(1, 2, 0.5))
  testthat::expect_output(print(v), ".{24}")
  testthat::expect_output(print(v, n = 2), ".{18}")
})
testthat::test_that("unordered_multimap print double string", {
  v <- cpp_unordered_multimap(seq.int(4, 4.2, 0.1), c("hello", "there", "world"))
  testthat::expect_output(print(v), ".{40}")
  testthat::expect_output(print(v, n = 2), ".{28}")
})
testthat::test_that("unordered_multimap print double boolean", {
  v <- cpp_unordered_multimap(seq.int(4, 4.2, 0.1), c(TRUE, FALSE, FALSE))
  testthat::expect_output(print(v), ".{33}")
  testthat::expect_output(print(v, n = 2), ".{24}")
})
testthat::test_that("unordered_multimap print string integer", {
  v <- cpp_unordered_multimap(c("a", "quick", "test"), 8:10)
  testthat::expect_output(print(v), ".{32}")
  testthat::expect_output(print(v, n = 2), ".{24}")
})
testthat::test_that("unordered_multimap print string double", {
  v <- cpp_unordered_multimap(c("a", "quick", "test"), seq.int(1, 2, 0.5))
  testthat::expect_output(print(v), ".{33}")
  testthat::expect_output(print(v, n = 2), ".{25}")
})
testthat::test_that("unordered_multimap print string string", {
  v <- cpp_unordered_multimap(c("a", "quick", "test"), c("hello", "there", "world"))
  testthat::expect_output(print(v), ".{49}")
  testthat::expect_output(print(v, n = 2), ".{35}")
})
testthat::test_that("unordered_multimap print string boolean", {
  v <- cpp_unordered_multimap(c("a", "quick", "test"), c(TRUE, FALSE, FALSE))
  testthat::expect_output(print(v), ".{42}")
  testthat::expect_output(print(v, n = 2), ".{31}")
})
testthat::test_that("unordered_multimap print boolean integer", {
  v <- cpp_unordered_multimap(c(TRUE, FALSE), 8:9)
  testthat::expect_output(print(v), ".{19}")
  testthat::expect_output(print(v, n = 1), ".{10}")
})
testthat::test_that("unordered_multimap print boolean double", {
  v <- cpp_unordered_multimap(c(TRUE, FALSE), seq.int(1, 1.5, 0.5))
  testthat::expect_output(print(v), ".{21}")
  testthat::expect_output(print(v, n = 1), ".{12}")
})
testthat::test_that("unordered_multimap print boolean string", {
  v <- cpp_unordered_multimap(c(TRUE, FALSE), c("hello", "there"))
  testthat::expect_output(print(v), ".{31}")
  testthat::expect_output(print(v, n = 1), ".{16}")
})
testthat::test_that("unordered_multimap print boolean boolean", {
  v <- cpp_unordered_multimap(c(TRUE, FALSE), c(TRUE, FALSE))
  testthat::expect_output(print(v), ".{26}")
  testthat::expect_output(print(v, n = 1), ".{14}")
})

# stack
testthat::test_that("stack print integer", {
  v <- cpp_stack(4:6)
  testthat::expect_output(print(v), "Top element: 6")
})
testthat::test_that("stack print double", {
  v <- cpp_stack(seq.int(1, 2, 0.5))
  testthat::expect_output(print(v), "Top element: 2")
})
testthat::test_that("stack print string", {
  v <- cpp_stack(c("hello", "there"))
  testthat::expect_output(print(v), "Top element: \"there\"")
})
testthat::test_that("stack print boolean", {
  v <- cpp_stack(c(TRUE, FALSE))
  testthat::expect_output(print(v), "Top element: FALSE")
})

# queue
testthat::test_that("queue print integer", {
  v <- cpp_queue(4:6)
  testthat::expect_output(print(v), "First element: 4")
})
testthat::test_that("queue print double", {
  v <- cpp_queue(seq.int(1, 2, 0.5))
  testthat::expect_output(print(v), "First element: 1")
})
testthat::test_that("queue print string", {
  v <- cpp_queue(c("hello", "there"))
  testthat::expect_output(print(v), "First element: \"hello\"")
})
testthat::test_that("queue print boolean", {
  v <- cpp_queue(c(TRUE, FALSE))
  testthat::expect_output(print(v), "First element: TRUE")
})

# priority_queue
testthat::test_that("priority_queue print integer descending", {
  v <- cpp_priority_queue(4:6)
  testthat::expect_output(print(v), "Top element: 6")
})
testthat::test_that("priority_queue print double descending", {
  v <- cpp_priority_queue(seq.int(1, 2, 0.5))
  testthat::expect_output(print(v), "Top element: 2")
})
testthat::test_that("priority_queue print string descending", {
  v <- cpp_priority_queue(c("hello", "there"))
  testthat::expect_output(print(v), "Top element: \"there\"")
})
testthat::test_that("priority_queue print boolean descending", {
  v <- cpp_priority_queue(c(TRUE, FALSE))
  testthat::expect_output(print(v), "Top element: TRUE")
})
testthat::test_that("priority_queue print integer ascending", {
  v <- cpp_priority_queue(4:6, "ascending")
  testthat::expect_output(print(v), "Top element: 4")
})
testthat::test_that("priority_queue print double ascending", {
  v <- cpp_priority_queue(seq.int(1, 2, 0.5), "ascending")
  testthat::expect_output(print(v), "Top element: 1")
})
testthat::test_that("priority_queue print string ascending", {
  v <- cpp_priority_queue(c("hello", "there"), "ascending")
  testthat::expect_output(print(v), "Top element: \"hello\"")
})
testthat::test_that("priority_queue print boolean ascending", {
  v <- cpp_priority_queue(c(TRUE, FALSE), "ascending")
  testthat::expect_output(print(v), "Top element: FALSE")
})

# vector
testthat::test_that("vector print integer", {
  v <- cpp_vector(4:6)
  testthat::expect_output(print(v), "4 5 6")
  testthat::expect_output(print(v, n = 2), "4 5")
  testthat::expect_output(print(v, n = -2), "6 5")
  testthat::expect_output(print(v, from = 3L), "6")
  testthat::expect_output(print(v, to = 1L), "4")
  testthat::expect_output(print(v, from = 3L, to = 3L), "6")
})
testthat::test_that("vector print double", {
  v <- cpp_vector(seq.int(1, 2, 0.5))
  testthat::expect_output(print(v), "1 1.5 2")
  testthat::expect_output(print(v, n = 2), "1 1.5")
  testthat::expect_output(print(v, n = -2), "2 1.5")
  testthat::expect_output(print(v, from = 3L), "2")
  testthat::expect_output(print(v, to = 1L), "1")
  testthat::expect_output(print(v, from = 3L, to = 3L), "2")
})
testthat::test_that("vector print string", {
  v <- cpp_vector(c("hello", "there", "world"))
  testthat::expect_output(print(v), "\"hello\" \"there\" \"world\"")
  testthat::expect_output(print(v, n = 2), "\"hello\" \"there\"")
  testthat::expect_output(print(v, n = -2), "\"world\" \"there\"")
  testthat::expect_output(print(v, from = 3L), "\"world\"")
  testthat::expect_output(print(v, to = 1L), "\"hello\"")
  testthat::expect_output(print(v, from = 3L, to = 3L), "\"world\"")
})
testthat::test_that("vector print boolean", {
  v <- cpp_vector(c(TRUE, FALSE, FALSE))
  testthat::expect_output(print(v), "TRUE FALSE FALSE")
  testthat::expect_output(print(v, n = 2), "TRUE FALSE")
  testthat::expect_output(print(v, n = -2), "FALSE FALSE")
  testthat::expect_output(print(v, from = 3L), "FALSE")
  testthat::expect_output(print(v, to = 1L), "TRUE")
  testthat::expect_output(print(v, from = 3L, to = 3L), "FALSE")
})

# deque
testthat::test_that("deque print integer", {
  v <- cpp_deque(4:6)
  testthat::expect_output(print(v), "4 5 6")
  testthat::expect_output(print(v, n = 2), "4 5")
  testthat::expect_output(print(v, n = -2), "6 5")
  testthat::expect_output(print(v, from = 3L), "6")
  testthat::expect_output(print(v, to = 1L), "4")
  testthat::expect_output(print(v, from = 3L, to = 3L), "6")
})
testthat::test_that("deque print double", {
  v <- cpp_deque(seq.int(1, 2, 0.5))
  testthat::expect_output(print(v), "1 1.5 2")
  testthat::expect_output(print(v, n = 2), "1 1.5")
  testthat::expect_output(print(v, n = -2), "2 1.5")
  testthat::expect_output(print(v, from = 3L), "2")
  testthat::expect_output(print(v, to = 1L), "1")
  testthat::expect_output(print(v, from = 3L, to = 3L), "2")
})
testthat::test_that("deque print string", {
  v <- cpp_deque(c("hello", "there", "world"))
  testthat::expect_output(print(v), "\"hello\" \"there\" \"world\"")
  testthat::expect_output(print(v, n = 2), "\"hello\" \"there\"")
  testthat::expect_output(print(v, n = -2), "\"world\" \"there\"")
  testthat::expect_output(print(v, from = 3L), "\"world\"")
  testthat::expect_output(print(v, to = 1L), "\"hello\"")
  testthat::expect_output(print(v, from = 3L, to = 3L), "\"world\"")
})
testthat::test_that("deque print boolean", {
  v <- cpp_deque(c(TRUE, FALSE, FALSE))
  testthat::expect_output(print(v), "TRUE FALSE FALSE")
  testthat::expect_output(print(v, n = 2), "TRUE FALSE")
  testthat::expect_output(print(v, n = -2), "FALSE FALSE")
  testthat::expect_output(print(v, from = 3L), "FALSE")
  testthat::expect_output(print(v, to = 1L), "TRUE")
  testthat::expect_output(print(v, from = 3L, to = 3L), "FALSE")
})

# forward_list
testthat::test_that("forward_list print integer", {
  v <- cpp_forward_list(4:6)
  testthat::expect_output(print(v), "4 5 6")
  testthat::expect_output(print(v, n = 2), "4 5")
})
testthat::test_that("forward_list print double", {
  v <- cpp_forward_list(seq.int(1, 2, 0.5))
  testthat::expect_output(print(v), "1 1.5 2")
  testthat::expect_output(print(v, n = 2), "1 1.5")
})
testthat::test_that("forward_list print string", {
  v <- cpp_forward_list(c("hello", "there", "world"))
  testthat::expect_output(print(v), "\"hello\" \"there\" \"world\"")
  testthat::expect_output(print(v, n = 2), "\"hello\" \"there\"")
})
testthat::test_that("forward_list print boolean", {
  v <- cpp_forward_list(c(TRUE, FALSE, FALSE))
  testthat::expect_output(print(v), "TRUE FALSE FALSE")
  testthat::expect_output(print(v, n = 2), "TRUE FALSE")
})

# list
testthat::test_that("list print integer", {
  v <- cpp_list(4:6)
  testthat::expect_output(print(v), "4 5 6")
  testthat::expect_output(print(v, n = 2), "4 5")
  testthat::expect_output(print(v, n = -2), "6 5")
})
testthat::test_that("list print double", {
  v <- cpp_list(seq.int(1, 2, 0.5))
  testthat::expect_output(print(v), "1 1.5 2")
  testthat::expect_output(print(v, n = 2), "1 1.5")
  testthat::expect_output(print(v, n = -2), "2 1.5")
})
testthat::test_that("list print string", {
  v <- cpp_list(c("hello", "there", "world"))
  testthat::expect_output(print(v), "\"hello\" \"there\" \"world\"")
  testthat::expect_output(print(v, n = 2), "\"hello\" \"there\"")
  testthat::expect_output(print(v, n = -2), "\"world\" \"there\"")
})
testthat::test_that("list print boolean", {
  v <- cpp_list(c(TRUE, FALSE, FALSE))
  testthat::expect_output(print(v), "TRUE FALSE FALSE")
  testthat::expect_output(print(v, n = 2), "TRUE FALSE")
  testthat::expect_output(print(v, n = -2), "FALSE FALSE")
})
