% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_distance_pair.R
\name{get_distance_pair}
\alias{get_distance_pair}
\title{Compute shortest distance between origin and destination nodes.}
\usage{
get_distance_pair(Graph, from, to, algorithm = "Dijkstra",
  constant = 1, allcores = FALSE)
}
\arguments{
\item{Graph}{An object generated by cppRouting::makegraph() function.}

\item{from}{A vector of one or more vertices from which distances are calculated (origin).}

\item{to}{A vector of one or more vertices (destination).}

\item{algorithm}{character. "Dijkstra" for uni-directional Dijkstra, "bi" for bi-directional Dijkstra, "A*" or "NBA" for New bi-directional A star .Default to "Dijkstra"}

\item{constant}{numeric. Constant to maintain the heuristic function admissible in A* algorithm. 
Default to 1, when cost is expressed in the same unit than coordinates. See details}

\item{allcores}{Logical. If TRUE, all cores are used.}
}
\value{
Vector of shortest distances.
}
\description{
Compute shortest distance between origin and destination nodes.
}
\details{
To perform A*, projected coordinates should be provided in the Graph object.  
In A* algorithms, euclidean distance is used as heuristic function.
To understand how A star algorithm work, see https://en.wikipedia.org/wiki/A*_search_algorithm .
To understand the importance of constant parameter, see the package description : https://github.com/vlarmet/cppRouting
}
\note{
'from' and 'to' must be the same length.
}
\examples{
#Data describing edges of the graph
edges<-data.frame(from_vertex=c(0,0,1,1,2,2,3,4,4), 
                  to_vertex=c(1,3,2,4,4,5,1,3,5), 
                  cost=c(9,2,11,3,5,12,4,1,6))

#Get all nodes
nodes<-unique(c(edges$from_vertex,edges$to_vertex))
 
#Construct directed and undirected graph 
directed_graph<-makegraph(edges,directed=TRUE)
non_directed<-makegraph(edges,directed=FALSE)

#Sampling origin and destination nodes
origin<-sample(nodes,10,replace=TRUE)
destination<-sample(nodes,10,replace=TRUE)

#Get distance between origin and destination in the two graphs
dir_dist<-get_distance_pair(Graph=directed_graph, from=origin, to=destination, allcores=FALSE)
non_dir_dist<-get_distance_pair(Graph=non_directed, from=origin, to=destination, allcores=FALSE)
print(dir_dist)
print(non_dir_dist)
}
