\name{print.tunecpfa}
\alias{print.tunecpfa}
\title{
Print Method for Tuning for Classification with Parallel Factor Analysis
}
\description{
Prints summary of a 'tunecpfa' model object generated by function 
\code{tunecpfa}. 
}
\usage{
\method{print}{tunecpfa}(x, ...)
}
\arguments{
\item{x}{
  A fit object of class 'tunecpfa' from function \code{tunecpfa}.
}
\item{...}{
  Additional print arguments.
}
}
\details{
Prints names of the models and methods used to create the input 'tunecpfa' 
model object. Prints misclassification error rates and estimation times in 
seconds.
}
\value{
Returns a summary of the 'tunecpfa' model object.
}
\author{
 Matthew Asisgress <mattgress@protonmail.ch>
}
\references{
See help file for function \code{tunecpfa} for a list of references.
}
\examples{
########## Parafac example with 3-way array and binary response ##########
\dontrun{
# set seed and simulate a three-way array connected to a binary response
set.seed(5)

# define target correlation matrix for columns of C mode weights matrix
cormat <- matrix(c(1, .6, .6, .6, 1, .6, .6, .6, 1), nrow = 3, ncol = 3)

# simulate a three-way array connected to a response
data <- simcpfa(arraydim = c(11, 12, 100), model = "parafac", nfac = 3, 
                nclass = 2, nreps = 1e2, onreps = 10, corresp = rep(.6, 3), 
                meanpred = rep(2, 3), modes = 3, corrpred = cormat,
                technical = techlist, smethod = "eigende")

# initialize
alpha <- seq(0, 1, length = 2)
gamma <- c(0, 0.01)
cost <- c(1, 2)
method <- c("PLR", "SVM")
family <- "binomial"
parameters <- list(alpha = alpha, gamma = gamma, cost = cost)
model <- "parafac"
nfolds <- 3
nstart <- 3

# constrain first mode weights to be orthogonal
const <- c("orthog", "uncons", "uncons")

# fit Parafac models and use third mode to tune classification methods
tune.object <- tunecpfa(x = data$X, y = as.factor(data$y), model = model, 
                        nfac = 3, nfolds = nfolds, method = method, 
                        family = family, parameters = parameters, 
                        parallel = FALSE, const = const, nstart = nstart)
                         
# print summary of output
print(tune.object)
}
}