% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_total_emissions.R
\name{calc_total_emissions}
\alias{calc_total_emissions}
\title{Calculate total emissions (robust and boundary-aware)}
\usage{
calc_total_emissions(...)
}
\arguments{
\item{...}{Results from \code{calc_emissions_*()} functions (lists).}
}
\value{
Object "cf_total" with breakdown (kg CO2eq by source) and total.
}
\description{
Aggregates results from different sources (enteric, manure, soil, energy, inputs)
even if they don't use exactly the same field name for the total.
IMPORTANT: If a source explicitly reports \code{co2eq_kg = NULL} (e.g. excluded by
system boundaries), it is treated as zero and no fallback summation is attempted.
}
\examples{
# Minimal, fast example (<1s)
enteric <- list(co2eq_kg = 45000, source = "enteric")
manure  <- list(co2eq_kg = 12000, source = "manure")
soil    <- list(co2eq_kg = 18000, source = "soil")
energy  <- list(co2eq_kg =  8000, source = "energy")
calc_total_emissions(enteric = enteric, manure = manure, soil = soil, energy = energy)

\donttest{
# Example with an excluded source (treated as zero)
inputs_excl <- list(source = "inputs", co2eq_kg = NULL, methodology = "excluded_by_boundaries")
calc_total_emissions(enteric, manure, soil, inputs_excl)
}
}
