% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srcref_df.R
\name{test_srcrefs_df}
\alias{test_srcrefs_df}
\title{Create a data.frame of coverage test srcref objects}
\usage{
test_srcrefs_df(x)
}
\arguments{
\item{x}{A \code{\link[covr]{package_coverage}} coverage object, from which
the name of the package used is extracted.}
}
\value{
A \code{data.frame} of test \code{srcrefs} extracted from a
\code{coverage} object. Contains one record for each \code{srcref} with
variables:

\describe{
\item{name}{
A \code{character} test description. For \code{testthat} tests, the
\code{desc} parameter will be used, otherwise a snippet of code will be
used for the test name
}
\item{srcref}{
A \code{srcref} object describing the location of the test
}
\item{test_type}{
A \code{character} indicating the structure of the test.  One of
\code{"testthat"}, \code{"call"} or \code{NULL}
}
}
}
\description{
Extract unit test \code{srcref}s from a
\code{\link[covr:package_coverage]{coverage}} object. A test name will be
derived from the test source code, preferrably from a written annotation, but
otherwise falling back to using a code snippet. \code{srcrefs} are unique for
each expression executed within a testing suite.
}
\examples{
options(covr.record_tests = TRUE)
pkg_path <- system.file("examplepkg", package = "covtracer")
cov <- covr::package_coverage(pkg_path)
test_srcrefs_df(cov)

}
\seealso{
srcrefs test_trace_mapping

Other srcrefs_df: 
\code{\link{pkg_srcrefs_df}()},
\code{\link{trace_srcrefs_df}()}
}
\concept{srcrefs_df}
