% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polycorr.R
\name{polycorr}
\alias{polycorr}
\title{Calculate Polychoric Correlations}
\usage{
polycorr(data, varlist)
}
\arguments{
\item{data}{data frame with "markname" and study names as column names.}

\item{varlist}{character vector of study names to include in the meta-analysis.}
}
\value{
data frame with polychoric correlation coefficients and standard errors
}
\description{
This function calculates the polychoric correlations between pairs of variables
in a given data frame. It returns a data frame with the row and column names of
the variables, the polychoric correlation coefficient, and its standard error.
}
\examples{
\donttest{
  data(snp_example)
  varlist <- c("trt1","trt2","trt3")
  polycorr(snp_example, varlist)
}

}
\seealso{
\code{\link{polychor}}
}
\author{
Woo Jung
}
