/*
 * Decompiled with CFR 0.152.
 */
package uno.informatics.common.io.text;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import uno.informatics.common.io.TextFileHandler;

public abstract class AbstractTextFileHandler
implements TextFileHandler {
    private String pathReference;
    private Path path;
    private boolean isInStrictMode;
    private String comment;
    private int currentRowSize = -1;
    private int rowPosition = -1;
    private int rowIndex = -1;
    private int columnIndex = -1;
    private boolean rowSizeSetExternally = false;
    private String delimiter;

    protected AbstractTextFileHandler() {
    }

    public AbstractTextFileHandler(String reference) throws IOException, FileNotFoundException {
        if (reference == null) {
            throw new FileNotFoundException("File undefined");
        }
        this.setFileReference(reference);
    }

    public AbstractTextFileHandler(Path path) throws IOException, FileNotFoundException {
        if (path == null) {
            throw new FileNotFoundException("Path undefined");
        }
        this.setPath(path);
    }

    public boolean ready() {
        return true;
    }

    public final int getRowCount() {
        if (!this.ready()) {
            return -1;
        }
        return this.getRowIndex();
    }

    public final int getColumnCount() {
        if (this.getCurrentRowSize() > -1) {
            return this.getCurrentRowSize();
        }
        return -1;
    }

    public final String getCommentString() {
        return this.comment;
    }

    public final String getPathReference() {
        return this.pathReference;
    }

    public final void setFileReference(String pathReference) throws IOException {
        if (this.pathReference != pathReference) {
            if (this.isInUse()) {
                throw new IOException("Path can not be changed while reader/writer is in use");
            }
            this.pathReference = pathReference;
            this.path = null;
        }
    }

    @Override
    public final Path getPath() {
        return this.path;
    }

    public final void setPath(Path path) throws IOException {
        if (this.path != path) {
            if (this.isInUse()) {
                throw new IOException("Path can not be changed while reader/writer is in use");
            }
            this.pathReference = null;
            this.path = path;
        }
    }

    public final boolean isInStrictMode() {
        return this.isInStrictMode;
    }

    public final void setInStrictMode(boolean isInStrictMode) throws IOException {
        if (this.isInStrictMode != isInStrictMode) {
            if (this.isInUse()) {
                throw new IOException("Mode can not be changed while reader/writer is in use");
            }
            this.isInStrictMode = isInStrictMode;
        }
    }

    public final synchronized void setCommentString(String comment) throws IOException {
        if (comment == null || comment.equals("")) {
            comment = "#";
        }
        if (!comment.equals(this.comment)) {
            if (this.isInUse()) {
                throw new IOException("Comment string can not be set while reader/writer is in use");
            }
            this.comment = comment;
        }
    }

    public final String getDelimiterString() {
        return this.delimiter;
    }

    public synchronized void setDelimiterString(String delimiter) throws IOException {
        if (delimiter == null || delimiter.equals("")) {
            delimiter = "\t";
        }
        if (!delimiter.equals(this.delimiter)) {
            if (this.isInUse()) {
                throw new IOException("Delimiter string can not be set while reader/writer is in use");
            }
            this.delimiter = delimiter;
        }
    }

    protected void initialise() throws FileNotFoundException, IOException {
        this.isInStrictMode = false;
        this.rowPosition = -1;
        this.rowIndex = -1;
        this.columnIndex = -1;
        this.comment = "#";
        if (this.delimiter == null || this.delimiter.equals("")) {
            this.delimiter = "\t";
        }
    }

    protected final void updateRowFromSize(List<Object> row) throws IOException {
        if (row != null && row.size() < this.getCurrentRowSize()) {
            for (int i = 0; i < row.size() - this.getCurrentRowSize(); ++i) {
                row.add(null);
            }
        }
    }

    public final int getCurrentRowSize() {
        return this.currentRowSize;
    }

    public final void setFixedRowSize(int rowSize) throws IOException {
        if (this.currentRowSize != rowSize) {
            if (this.isInUse()) {
                throw new IOException("Row size can not be set while reader/writer is in use");
            }
            this.setCurrentRowSize(rowSize);
        }
        this.rowSizeSetExternally = rowSize >= 0;
    }

    protected final void setCurrentRowSize(int rowSize) {
        this.currentRowSize = rowSize;
    }

    protected void updateRowSize(int rowSize) {
        if (!this.rowSizeSetExternally) {
            this.setCurrentRowSize(rowSize);
        }
    }

    protected final int getRowIndex() {
        return this.rowIndex;
    }

    protected final void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    protected final void incrementRowIndex() {
        ++this.rowIndex;
    }

    protected final int getRowPosition() {
        return this.rowPosition;
    }

    protected final void setRowPosition(int rowPosition) {
        this.rowPosition = rowPosition;
    }

    protected final void incrementRowPosition() {
        ++this.rowPosition;
    }

    protected final boolean isInUse() {
        return this.rowIndex > -1;
    }

    protected final int getColumnIndex() {
        return this.columnIndex;
    }

    protected final void setColumnIndex(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    protected final void incrementColumnIndex() {
        ++this.columnIndex;
    }

    protected final void resetCellIndex() {
        this.columnIndex = -1;
    }

    protected final boolean isRowSizeSetExternally() {
        return this.rowSizeSetExternally;
    }
}

