/*
 * Decompiled with CFR 0.152.
 */
package org.corehunter.data.simple;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.corehunter.data.DistanceMatrixData;
import org.jamesframework.core.subset.SubsetSolution;
import uno.informatics.common.io.IOUtilities;
import uno.informatics.common.io.RowReader;
import uno.informatics.common.io.RowWriter;
import uno.informatics.data.SimpleEntity;
import uno.informatics.data.io.FileType;
import uno.informatics.data.pojo.DataPojo;
import uno.informatics.data.pojo.SimpleEntityPojo;

public class SimpleDistanceMatrixData
extends DataPojo
implements DistanceMatrixData {
    private static final long serialVersionUID = 1L;
    private static final double DELTA = 1.0E-10;
    private static final String ID_HEADER = "X";
    private static final String IDENTIFIERS_HEADER = "ID";
    private static final String NAMES_HEADER = "NAME";
    private static final String SELECTED_HEADER = "SELECTED";
    private final double[][] distances;

    public SimpleDistanceMatrixData(SimpleEntity[] headers, double[][] distances) {
        this("Precomputed distance matrix", headers, distances);
    }

    public SimpleDistanceMatrixData(String name, SimpleEntity[] headers, double[][] distances) {
        super(name, headers);
        int n = distances.length;
        this.distances = new double[n][n];
        for (int r = 0; r < n; ++r) {
            if (distances[r].length != n) {
                throw new IllegalArgumentException(String.format("Number of distances in row %d does not match number of rows.", r));
            }
            for (int c = 0; c < n; ++c) {
                if (distances[r][c] < 0.0) {
                    throw new IllegalArgumentException("All distances should be positive.");
                }
                if (Math.abs(distances[r][c] - distances[c][r]) > 1.0E-10) {
                    throw new IllegalArgumentException("Distance matrix should be symmetric.");
                }
                if (r == c && distances[r][c] > 1.0E-10) {
                    throw new IllegalArgumentException("Diagonal values should be zero.");
                }
                this.distances[r][c] = distances[r][c];
            }
        }
    }

    @Override
    public double getDistance(int idX, int idY) {
        return this.distances[idX][idY];
    }

    public static SimpleDistanceMatrixData readData(Path filePath, FileType type) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException("File path not defined.");
        }
        if (!filePath.toFile().exists()) {
            throw new IOException("File does not exist : " + filePath + ".");
        }
        if (type == null) {
            throw new IllegalArgumentException("File type not defined.");
        }
        if (type != FileType.TXT && type != FileType.CSV) {
            throw new IllegalArgumentException(String.format("Only file types TXT and CSV are supported. Got: %s.", new Object[]{type}));
        }
        try (RowReader reader = IOUtilities.createRowReader(filePath, type, 16, 32);){
            int i;
            int i2;
            if (reader == null || !reader.ready()) {
                throw new IOException("Can not create reader for file " + filePath + ". File may be empty.");
            }
            if (!reader.hasNextRow()) {
                throw new IOException("File is empty.");
            }
            ArrayList<String[]> rows = new ArrayList<String[]>();
            while (reader.nextRow()) {
                rows.add(reader.getRowCellsAsStringArray());
            }
            int n = rows.size() - 1;
            if (n <= 0) {
                throw new IOException("No data.");
            }
            String[] firstRow = (String[])rows.get(0);
            if (firstRow.length == 0 || !Objects.equals(IDENTIFIERS_HEADER, firstRow[0])) {
                throw new IOException("Missing ID column.");
            }
            int numHeaderCols = 1;
            boolean withNames = false;
            if (firstRow.length > 1 && Objects.equals(NAMES_HEADER, firstRow[1])) {
                withNames = true;
                ++numHeaderCols;
            }
            String[] ids = new String[n];
            String[] names = new String[n];
            for (i2 = 0; i2 < n; ++i2) {
                ids[i2] = ((String[])rows.get(i2 + 1))[0];
                names[i2] = withNames ? ((String[])rows.get(i2 + 1))[1] : ids[i2];
            }
            if (firstRow.length > numHeaderCols) {
                for (i2 = 0; i2 < n; ++i2) {
                    if (numHeaderCols + i2 < firstRow.length && Objects.equals(ids[i2], firstRow[numHeaderCols + i2])) continue;
                    throw new IOException("Row and column identifiers differ.");
                }
            }
            Double[][] dist = new Double[n][n];
            for (i = 0; i < n; ++i) {
                String[] row = (String[])rows.get(i + 1);
                if (row.length - numHeaderCols < i) {
                    throw new IOException("Too few values at row " + (i + 1) + ".");
                }
                if (row.length - numHeaderCols > n) {
                    throw new IOException("Too many values at row " + (i + 1) + ".");
                }
                for (int j = 0; j < row.length - numHeaderCols; ++j) {
                    Double d;
                    String entry = row[numHeaderCols + j];
                    dist[i][j] = d = entry == null ? null : Double.valueOf(Double.parseDouble(entry));
                }
            }
            for (i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    Double d = dist[i][j];
                    if (i > j) {
                        if (d != null) continue;
                        throw new IOException(String.format("Missing value at row %d, col %d.", i + 1, numHeaderCols + j));
                    }
                    if (i == j) {
                        if (d != null) {
                            if (!(d > 1.0E-10)) continue;
                            throw new IOException("Non-zero diagonal value at row " + (i + 1) + ".");
                        }
                        dist[i][j] = 0.0;
                        continue;
                    }
                    if (dist[j][i] == null) {
                        throw new IOException(String.format("Missing value at row %d, col %d.", j + 1, numHeaderCols + i));
                    }
                    if (d != null) {
                        if (!(Math.abs(d - dist[j][i]) > 1.0E-10)) continue;
                        throw new IOException("Matrix is not symmetric.");
                    }
                    dist[i][j] = dist[j][i];
                }
            }
            double[][] distances = new double[n][n];
            for (int i3 = 0; i3 < n; ++i3) {
                for (int j = 0; j < n; ++j) {
                    distances[i3][j] = dist[i3][j];
                }
            }
            SimpleEntity[] headers = new SimpleEntity[n];
            for (int i4 = 0; i4 < n; ++i4) {
                headers[i4] = names[i4] != null ? new SimpleEntityPojo(ids[i4], names[i4]) : new SimpleEntityPojo(ids[i4]);
            }
            SimpleDistanceMatrixData simpleDistanceMatrixData = new SimpleDistanceMatrixData(filePath.getFileName().toString(), headers, distances);
            return simpleDistanceMatrixData;
        }
    }

    public void writeData(Path filePath, FileType fileType) throws IOException {
        SubsetSolution all = new SubsetSolution(this.getIDs());
        all.selectAll();
        this.writeData(filePath, fileType, all, false, true, false);
    }

    public void writeData(Path filePath, FileType fileType, SubsetSolution solution, boolean includeId, boolean includeSelected, boolean includeUnselected) throws IOException {
        if (filePath.toFile().exists()) {
            throw new IOException("File already exists: " + filePath + ".");
        }
        if (fileType == null) {
            throw new IllegalArgumentException("File type not defined.");
        }
        if (fileType != FileType.TXT && fileType != FileType.CSV) {
            throw new IllegalArgumentException(String.format("Only file types TXT and CSV are supported. Got: %s.", new Object[]{fileType}));
        }
        if (solution == null) {
            throw new NullPointerException("Solution must be defined");
        }
        if (!solution.getAllIDs().equals(this.getIDs())) {
            throw new IllegalArgumentException("Solution ids must match data.");
        }
        if (!includeSelected && !includeUnselected) {
            throw new IllegalArgumentException("One of 'includeSelected' or 'includeUnselected' must be used.");
        }
        Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
        boolean markSelection = includeSelected && includeUnselected;
        try (RowWriter writer = IOUtilities.createRowWriter(filePath, fileType, 16);){
            Set<Integer> includedIDs;
            if (writer == null || !writer.ready()) {
                throw new IOException("Can not create writer for file " + filePath + ".");
            }
            if (includeId) {
                writer.writeCell(ID_HEADER);
                writer.newColumn();
            }
            writer.writeCell(IDENTIFIERS_HEADER);
            writer.newColumn();
            writer.writeCell(NAMES_HEADER);
            if (markSelection) {
                writer.newColumn();
                writer.writeCell(SELECTED_HEADER);
            }
            for (int i = 0; i < this.getSize(); ++i) {
                writer.newColumn();
                writer.writeCell(this.getHeader(i).getUniqueIdentifier());
            }
            if (markSelection) {
                includedIDs = this.getIDs();
            } else if (includeSelected) {
                includedIDs = solution.getSelectedIDs();
            } else if (includeUnselected) {
                includedIDs = solution.getUnselectedIDs();
            } else {
                throw new IllegalArgumentException("One of 'includeSelected' or 'includeUnselected' must be used.");
            }
            ArrayList<Integer> sortedIDs = new ArrayList<Integer>(includedIDs);
            sortedIDs.sort(null);
            Set<Integer> selected = solution.getSelectedIDs();
            Iterator iterator = sortedIDs.iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                writer.newRow();
                if (includeId) {
                    writer.writeCell(id);
                    writer.newColumn();
                }
                SimpleEntity header = this.getHeader(id);
                writer.writeCell(header.getUniqueIdentifier());
                writer.newColumn();
                writer.writeCell(header.getName());
                if (markSelection) {
                    writer.newColumn();
                    writer.writeCell(selected.contains(id));
                }
                for (int j = 0; j < this.getSize(); ++j) {
                    writer.newColumn();
                    writer.writeCell(this.distances[id][j]);
                }
            }
            writer.close();
        }
    }
}

