/*
 * Decompiled with CFR 0.152.
 */
package org.corehunter.objectives.eval;

import java.util.Collection;
import java.util.Set;
import org.corehunter.data.GenotypeData;
import org.corehunter.objectives.eval.AllelicDiversityEvaluation;

public class CoverageEvaluation
extends AllelicDiversityEvaluation {
    private static final double TOL = 1.0E-10;

    public CoverageEvaluation(Collection<Integer> ids, GenotypeData data) {
        super(ids, data);
    }

    public CoverageEvaluation(AllelicDiversityEvaluation curEval, Set<Integer> add, Set<Integer> remove, GenotypeData data) {
        super(curEval, add, remove, data);
    }

    @Override
    public double getValue() {
        double[][] avgGeno = this.getAverageGenotype();
        int numberOfMarkers = avgGeno.length;
        int totalNumberOfAlleles = 0;
        int alleleCount = 0;
        for (int m = 0; m < numberOfMarkers; ++m) {
            int numberOfAlleles = avgGeno[m].length;
            totalNumberOfAlleles += numberOfAlleles;
            for (int a = 0; a < numberOfAlleles; ++a) {
                if (!(avgGeno[m][a] > 1.0E-10)) continue;
                ++alleleCount;
            }
        }
        return (double)alleleCount / (double)totalNumberOfAlleles;
    }
}

