/*
 * Decompiled with CFR 0.152.
 */
package org.corehunter.data.simple;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.corehunter.data.BiAllelicGenotypeData;
import org.corehunter.data.GenotypeDataFormat;
import org.corehunter.data.simple.SimpleGenotypeData;
import org.corehunter.util.StringUtils;
import uno.informatics.common.io.IOUtilities;
import uno.informatics.common.io.RowReader;
import uno.informatics.common.io.RowWriter;
import uno.informatics.data.SimpleEntity;
import uno.informatics.data.io.FileType;
import uno.informatics.data.pojo.SimpleEntityPojo;

public class SimpleBiAllelicGenotypeData
extends SimpleGenotypeData
implements BiAllelicGenotypeData {
    private static final String NAMES_HEADER = "NAME";
    private static final String IDENTIFIERS_HEADER = "ID";
    private final Integer[][] alleleScores;

    public SimpleBiAllelicGenotypeData(SimpleEntity[] itemHeaders, String[] markerNames, Integer[][] alleleScores) {
        this("Biallelic marker data", itemHeaders, markerNames, alleleScores);
    }

    public SimpleBiAllelicGenotypeData(String datasetName, SimpleEntity[] itemHeaders, String[] markerNames, Integer[][] alleleScores) {
        super(datasetName, itemHeaders, markerNames, SimpleBiAllelicGenotypeData.inferAlleleNames(alleleScores), SimpleBiAllelicGenotypeData.inferAlleleFrequencies(alleleScores));
        int i;
        int n = alleleScores.length;
        int m = -1;
        if (n == 0) {
            throw new IllegalArgumentException("No data (zero rows).");
        }
        for (i = 0; i < n; ++i) {
            Integer[] geno = alleleScores[i];
            if (geno == null) {
                throw new IllegalArgumentException(String.format("Allele scores not defined for item %d.", i));
            }
            if (m == -1) {
                m = geno.length;
                if (m == 0) {
                    throw new IllegalArgumentException("No markers (zero columns)");
                }
            } else if (geno.length != m) {
                throw new IllegalArgumentException(String.format("Incorrect number of markers for item %d. Expected: %d, actual: %d.", i, m, geno.length));
            }
            for (int j = 0; j < m; ++j) {
                if (geno[j] == null || geno[j] >= 0 && geno[j] <= 2) continue;
                throw new IllegalArgumentException(String.format("Unexpected value at data row %d and data column %d. Got: %d (allowed: 0, 1, 2).", i, j, geno[j]));
            }
        }
        this.alleleScores = new Integer[n][m];
        for (i = 0; i < n; ++i) {
            this.alleleScores[i] = Arrays.copyOf(alleleScores[i], m);
        }
    }

    private static String[][] inferAlleleNames(Integer[][] alleleScores) {
        int numMarkers = alleleScores[0].length;
        String[][] alleleNames = new String[numMarkers][2];
        for (int m = 0; m < numMarkers; ++m) {
            alleleNames[m][0] = "0";
            alleleNames[m][1] = "1";
        }
        return alleleNames;
    }

    private static Double[][][] inferAlleleFrequencies(Integer[][] alleleScores) {
        int numGenotypes = alleleScores.length;
        int numMarkers = alleleScores[0].length;
        Double[][][] freqs = new Double[numGenotypes][numMarkers][2];
        for (int i = 0; i < numGenotypes; ++i) {
            for (int m = 0; m < numMarkers; ++m) {
                if (alleleScores[i][m] == null) {
                    freqs[i][m][1] = null;
                    freqs[i][m][0] = null;
                    continue;
                }
                freqs[i][m][1] = (double)alleleScores[i][m].intValue() / 2.0;
                freqs[i][m][0] = 1.0 - freqs[i][m][1];
            }
        }
        return freqs;
    }

    @Override
    public Integer getAlleleScore(int id, int markerIndex) {
        return this.alleleScores[id][markerIndex];
    }

    public static SimpleBiAllelicGenotypeData readData(Path filePath, FileType type) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException("File path not defined.");
        }
        if (!filePath.toFile().exists()) {
            throw new IOException("File does not exist : " + filePath + ".");
        }
        if (type == null) {
            throw new IllegalArgumentException("File type not defined.");
        }
        if (type != FileType.TXT && type != FileType.CSV) {
            throw new IllegalArgumentException(String.format("Only file types TXT and CSV are supported. Got: %s.", new Object[]{type}));
        }
        Throwable throwable = null;
        try (RowReader reader = IOUtilities.createRowReader(filePath, type, 16);){
            if (reader == null || !reader.ready()) {
                throw new IOException("Can not create reader for file " + filePath + ". File may be empty.");
            }
            if (!reader.hasNextRow()) {
                throw new IOException("File is empty.");
            }
            ArrayList<String[]> rows = new ArrayList<String[]>();
            while (reader.nextRow()) {
                rows.add(StringUtils.unquote(reader.getRowCellsAsStringArray()));
            }
            if (rows.isEmpty()) {
                throw new IOException("File is empty.");
            }
            int numCols = rows.stream().mapToInt(row -> ((String[])row).length).max().getAsInt();
            for (int r = 0; r < rows.size(); ++r) {
                String[] row2 = (String[])rows.get(r);
                if (row2.length < numCols) {
                    row2 = Arrays.copyOf(row2, numCols);
                }
                rows.set(r, row2);
            }
            String[] firstRow = (String[])rows.get(0);
            if (firstRow.length == 0 || !Objects.equals(firstRow[0], IDENTIFIERS_HEADER)) {
                throw new IOException("Missing header row/column ID.");
            }
            boolean withNames = firstRow.length >= 2 && Objects.equals(firstRow[1], NAMES_HEADER);
            int numHeaderCols = 1;
            if (withNames) {
                ++numHeaderCols;
            }
            int numHeaderRows = 1;
            int n = rows.size() - numHeaderRows;
            if (n == 0) {
                throw new IOException("No data rows.");
            }
            int m = numCols - numHeaderCols;
            if (m == 0) {
                throw new IOException("No data columns.");
            }
            String[] markerNames = new String[m];
            for (int c = numHeaderCols; c < firstRow.length; ++c) {
                markerNames[c - numHeaderCols] = firstRow[c];
            }
            String[] itemNames = new String[n];
            String[] itemIdentifiers = new String[n];
            Integer[][] alleleScores = new Integer[n][m];
            for (int i = 0; i < n; ++i) {
                String[] row3 = (String[])rows.get(numHeaderRows + i);
                itemIdentifiers[i] = row3[0];
                itemNames[i] = withNames ? row3[1] : itemIdentifiers[i];
                for (int j = 0; j < m; ++j) {
                    String s = row3[numHeaderCols + j];
                    try {
                        alleleScores[i][j] = s == null ? null : Integer.valueOf(Integer.parseInt(s.trim()));
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        throw new IOException(String.format("Invalid allele score at row %d, column %d. Expected integer value 0/1/2, got: \"%s\".", numHeaderRows + i, numHeaderCols + j, s), ex);
                    }
                }
            }
            SimpleEntity[] headers = new SimpleEntity[n];
            for (int i = 0; i < n; ++i) {
                headers[i] = itemNames[i] != null ? new SimpleEntityPojo(itemIdentifiers[i], itemNames[i]) : new SimpleEntityPojo(itemIdentifiers[i]);
            }
            try {
                SimpleBiAllelicGenotypeData i = new SimpleBiAllelicGenotypeData(filePath.getFileName().toString(), headers, markerNames, alleleScores);
                return i;
            }
            catch (IllegalArgumentException ex) {
                try {
                    throw new IOException(ex.getMessage());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    @Override
    public List<GenotypeDataFormat> getSupportedOutputFormats() {
        return Arrays.asList(GenotypeDataFormat.FREQUENCY, GenotypeDataFormat.BIPARENTAL);
    }

    @Override
    public void writeData(Path filePath, FileType fileType) throws IOException {
        this.writeData(filePath, fileType, GenotypeDataFormat.BIPARENTAL);
    }

    @Override
    public void writeData(Path filePath, FileType fileType, GenotypeDataFormat format) throws IOException {
        if (format == null) {
            throw new IllegalArgumentException("Output format not defined.");
        }
        switch (format) {
            case BIPARENTAL: {
                this.writeBiallelicData(filePath, fileType);
                break;
            }
            default: {
                super.writeData(filePath, fileType, format);
            }
        }
    }

    private void writeBiallelicData(Path filePath, FileType fileType) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException("File path not defined.");
        }
        if (filePath.toFile().exists()) {
            throw new IOException("File already exists : " + filePath + ".");
        }
        if (fileType == null) {
            throw new IllegalArgumentException("File type not defined.");
        }
        if (fileType != FileType.TXT && fileType != FileType.CSV) {
            throw new IllegalArgumentException(String.format("Only file types TXT and CSV are supported. Got: %s.", new Object[]{fileType}));
        }
        Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
        try (RowWriter writer = IOUtilities.createRowWriter(filePath, fileType, 16);){
            if (writer == null || !writer.ready()) {
                throw new IOException("Can not create writer for file " + filePath + ".");
            }
            writer.writeCell(IDENTIFIERS_HEADER);
            writer.newColumn();
            writer.writeCell(NAMES_HEADER);
            for (int m = 0; m < this.getNumberOfMarkers(); ++m) {
                writer.newColumn();
                writer.writeCell(this.getMarkerName(m));
            }
            for (int r = 0; r < this.alleleScores.length; ++r) {
                writer.newRow();
                SimpleEntity header = this.getHeader(r);
                writer.writeCell(header.getUniqueIdentifier());
                writer.newColumn();
                writer.writeCell(header.getName());
                writer.newColumn();
                writer.writeRowCellsAsArray(this.alleleScores[r]);
            }
            writer.close();
        }
    }
}

